package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait ChangeSetHooksStatus {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.ChangeSetHooksStatus
}
object ChangeSetHooksStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.ChangeSetHooksStatus
  ): zio.aws.cloudformation.model.ChangeSetHooksStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.ChangeSetHooksStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSetHooksStatus.PLANNING =>
      val r = PLANNING
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSetHooksStatus.PLANNED =>
      val r = PLANNED
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSetHooksStatus.UNAVAILABLE =>
      val r = UNAVAILABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.ChangeSetHooksStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSetHooksStatus =
      software.amazon.awssdk.services.cloudformation.model.ChangeSetHooksStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PLANNING
      extends zio.aws.cloudformation.model.ChangeSetHooksStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSetHooksStatus =
      software.amazon.awssdk.services.cloudformation.model.ChangeSetHooksStatus.PLANNING
  }
  case object PLANNED
      extends zio.aws.cloudformation.model.ChangeSetHooksStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSetHooksStatus =
      software.amazon.awssdk.services.cloudformation.model.ChangeSetHooksStatus.PLANNED
  }
  case object UNAVAILABLE
      extends zio.aws.cloudformation.model.ChangeSetHooksStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSetHooksStatus =
      software.amazon.awssdk.services.cloudformation.model.ChangeSetHooksStatus.UNAVAILABLE
  }
}
