package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ClientRequestToken,
  Region,
  Account,
  StackSetNameOrId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateStackInstancesRequest(
    stackSetName: StackSetNameOrId,
    accounts: Option[Iterable[Account]] = None,
    deploymentTargets: Option[zio.aws.cloudformation.model.DeploymentTargets] =
      None,
    regions: Iterable[Region],
    parameterOverrides: Option[
      Iterable[zio.aws.cloudformation.model.Parameter]
    ] = None,
    operationPreferences: Option[
      zio.aws.cloudformation.model.StackSetOperationPreferences
    ] = None,
    operationId: Option[ClientRequestToken] = None,
    callAs: Option[zio.aws.cloudformation.model.CallAs] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesRequest = {
    import UpdateStackInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesRequest
      .builder()
      .stackSetName(StackSetNameOrId.unwrap(stackSetName): java.lang.String)
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            Account.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accounts)
      .optionallyWith(deploymentTargets.map(value => value.buildAwsValue()))(
        _.deploymentTargets
      )
      .regions(regions.map { item =>
        Region.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        parameterOverrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterOverrides)
      .optionallyWith(operationPreferences.map(value => value.buildAwsValue()))(
        _.operationPreferences
      )
      .optionallyWith(
        operationId.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.operationId)
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.UpdateStackInstancesRequest.ReadOnly =
    zio.aws.cloudformation.model.UpdateStackInstancesRequest
      .wrap(buildAwsValue())
}
object UpdateStackInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.UpdateStackInstancesRequest =
      zio.aws.cloudformation.model.UpdateStackInstancesRequest(
        stackSetName,
        accounts.map(value => value),
        deploymentTargets.map(value => value.asEditable),
        regions,
        parameterOverrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        operationPreferences.map(value => value.asEditable),
        operationId.map(value => value),
        callAs.map(value => value)
      )
    def stackSetName: StackSetNameOrId
    def accounts: Option[List[Account]]
    def deploymentTargets
        : Option[zio.aws.cloudformation.model.DeploymentTargets.ReadOnly]
    def regions: List[Region]
    def parameterOverrides
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def operationPreferences: Option[
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ]
    def operationId: Option[ClientRequestToken]
    def callAs: Option[zio.aws.cloudformation.model.CallAs]
    def getStackSetName: ZIO[Any, Nothing, StackSetNameOrId] =
      ZIO.succeed(stackSetName)
    def getAccounts: ZIO[Any, AwsError, List[Account]] =
      AwsError.unwrapOptionField("accounts", accounts)
    def getDeploymentTargets: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.DeploymentTargets.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentTargets", deploymentTargets)
    def getRegions: ZIO[Any, Nothing, List[Region]] = ZIO.succeed(regions)
    def getParameterOverrides: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterOverrides", parameterOverrides)
    def getOperationPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField("operationPreferences", operationPreferences)
    def getOperationId: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("operationId", operationId)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesRequest
  ) extends zio.aws.cloudformation.model.UpdateStackInstancesRequest.ReadOnly {
    override val stackSetName: StackSetNameOrId =
      zio.aws.cloudformation.model.primitives
        .StackSetNameOrId(impl.stackSetName())
    override val accounts: Option[List[Account]] = scala
      .Option(impl.accounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.Account(item)
        }.toList
      )
    override val deploymentTargets
        : Option[zio.aws.cloudformation.model.DeploymentTargets.ReadOnly] =
      scala
        .Option(impl.deploymentTargets())
        .map(value =>
          zio.aws.cloudformation.model.DeploymentTargets.wrap(value)
        )
    override val regions: List[Region] = impl
      .regions()
      .asScala
      .map { item =>
        zio.aws.cloudformation.model.primitives.Region(item)
      }
      .toList
    override val parameterOverrides
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameterOverrides())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Parameter.wrap(item)
        }.toList
      )
    override val operationPreferences: Option[
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ] = scala
      .Option(impl.operationPreferences())
      .map(value =>
        zio.aws.cloudformation.model.StackSetOperationPreferences.wrap(value)
      )
    override val operationId: Option[ClientRequestToken] = scala
      .Option(impl.operationId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
      )
    override val callAs: Option[zio.aws.cloudformation.model.CallAs] = scala
      .Option(impl.callAs())
      .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesRequest
  ): zio.aws.cloudformation.model.UpdateStackInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
