package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.TypeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TestTypeResponse(typeVersionArn: Option[TypeArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.TestTypeResponse = {
    import TestTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.TestTypeResponse
      .builder()
      .optionallyWith(
        typeVersionArn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.typeVersionArn)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.TestTypeResponse.ReadOnly =
    zio.aws.cloudformation.model.TestTypeResponse.wrap(buildAwsValue())
}
object TestTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.TestTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.TestTypeResponse =
      zio.aws.cloudformation.model
        .TestTypeResponse(typeVersionArn.map(value => value))
    def typeVersionArn: Option[TypeArn]
    def getTypeVersionArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("typeVersionArn", typeVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.TestTypeResponse
  ) extends zio.aws.cloudformation.model.TestTypeResponse.ReadOnly {
    override val typeVersionArn: Option[TypeArn] = scala
      .Option(impl.typeVersionArn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.TestTypeResponse
  ): zio.aws.cloudformation.model.TestTypeResponse.ReadOnly = new Wrapper(impl)
}
