package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  Timestamp,
  Description,
  StackSetId,
  StackSetName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StackSetSummary(
    stackSetName: Option[StackSetName] = None,
    stackSetId: Option[StackSetId] = None,
    description: Option[Description] = None,
    status: Option[zio.aws.cloudformation.model.StackSetStatus] = None,
    autoDeployment: Option[zio.aws.cloudformation.model.AutoDeployment] = None,
    permissionModel: Option[zio.aws.cloudformation.model.PermissionModels] =
      None,
    driftStatus: Option[zio.aws.cloudformation.model.StackDriftStatus] = None,
    lastDriftCheckTimestamp: Option[Timestamp] = None,
    managedExecution: Option[zio.aws.cloudformation.model.ManagedExecution] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackSetSummary = {
    import StackSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackSetSummary
      .builder()
      .optionallyWith(
        stackSetName.map(value => StackSetName.unwrap(value): java.lang.String)
      )(_.stackSetName)
      .optionallyWith(
        stackSetId.map(value => StackSetId.unwrap(value): java.lang.String)
      )(_.stackSetId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(autoDeployment.map(value => value.buildAwsValue()))(
        _.autoDeployment
      )
      .optionallyWith(permissionModel.map(value => value.unwrap))(
        _.permissionModel
      )
      .optionallyWith(driftStatus.map(value => value.unwrap))(_.driftStatus)
      .optionallyWith(
        lastDriftCheckTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastDriftCheckTimestamp)
      .optionallyWith(managedExecution.map(value => value.buildAwsValue()))(
        _.managedExecution
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.StackSetSummary.ReadOnly =
    zio.aws.cloudformation.model.StackSetSummary.wrap(buildAwsValue())
}
object StackSetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackSetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackSetSummary =
      zio.aws.cloudformation.model.StackSetSummary(
        stackSetName.map(value => value),
        stackSetId.map(value => value),
        description.map(value => value),
        status.map(value => value),
        autoDeployment.map(value => value.asEditable),
        permissionModel.map(value => value),
        driftStatus.map(value => value),
        lastDriftCheckTimestamp.map(value => value),
        managedExecution.map(value => value.asEditable)
      )
    def stackSetName: Option[StackSetName]
    def stackSetId: Option[StackSetId]
    def description: Option[Description]
    def status: Option[zio.aws.cloudformation.model.StackSetStatus]
    def autoDeployment
        : Option[zio.aws.cloudformation.model.AutoDeployment.ReadOnly]
    def permissionModel: Option[zio.aws.cloudformation.model.PermissionModels]
    def driftStatus: Option[zio.aws.cloudformation.model.StackDriftStatus]
    def lastDriftCheckTimestamp: Option[Timestamp]
    def managedExecution
        : Option[zio.aws.cloudformation.model.ManagedExecution.ReadOnly]
    def getStackSetName: ZIO[Any, AwsError, StackSetName] =
      AwsError.unwrapOptionField("stackSetName", stackSetName)
    def getStackSetId: ZIO[Any, AwsError, StackSetId] =
      AwsError.unwrapOptionField("stackSetId", stackSetId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.StackSetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getAutoDeployment: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.AutoDeployment.ReadOnly
    ] = AwsError.unwrapOptionField("autoDeployment", autoDeployment)
    def getPermissionModel
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.PermissionModels] =
      AwsError.unwrapOptionField("permissionModel", permissionModel)
    def getDriftStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.StackDriftStatus] =
      AwsError.unwrapOptionField("driftStatus", driftStatus)
    def getLastDriftCheckTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastDriftCheckTimestamp", lastDriftCheckTimestamp)
    def getManagedExecution: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.ManagedExecution.ReadOnly
    ] = AwsError.unwrapOptionField("managedExecution", managedExecution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetSummary
  ) extends zio.aws.cloudformation.model.StackSetSummary.ReadOnly {
    override val stackSetName: Option[StackSetName] = scala
      .Option(impl.stackSetName())
      .map(value => zio.aws.cloudformation.model.primitives.StackSetName(value))
    override val stackSetId: Option[StackSetId] = scala
      .Option(impl.stackSetId())
      .map(value => zio.aws.cloudformation.model.primitives.StackSetId(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val status: Option[zio.aws.cloudformation.model.StackSetStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.cloudformation.model.StackSetStatus.wrap(value))
    override val autoDeployment
        : Option[zio.aws.cloudformation.model.AutoDeployment.ReadOnly] = scala
      .Option(impl.autoDeployment())
      .map(value => zio.aws.cloudformation.model.AutoDeployment.wrap(value))
    override val permissionModel
        : Option[zio.aws.cloudformation.model.PermissionModels] = scala
      .Option(impl.permissionModel())
      .map(value => zio.aws.cloudformation.model.PermissionModels.wrap(value))
    override val driftStatus
        : Option[zio.aws.cloudformation.model.StackDriftStatus] = scala
      .Option(impl.driftStatus())
      .map(value => zio.aws.cloudformation.model.StackDriftStatus.wrap(value))
    override val lastDriftCheckTimestamp: Option[Timestamp] = scala
      .Option(impl.lastDriftCheckTimestamp())
      .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
    override val managedExecution
        : Option[zio.aws.cloudformation.model.ManagedExecution.ReadOnly] = scala
      .Option(impl.managedExecution())
      .map(value => zio.aws.cloudformation.model.ManagedExecution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetSummary
  ): zio.aws.cloudformation.model.StackSetSummary.ReadOnly = new Wrapper(impl)
}
