package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.ManagedExecutionNullable
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ManagedExecution(
    active: Option[ManagedExecutionNullable] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ManagedExecution = {
    import ManagedExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ManagedExecution
      .builder()
      .optionallyWith(
        active.map(value =>
          ManagedExecutionNullable.unwrap(value): java.lang.Boolean
        )
      )(_.active)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ManagedExecution.ReadOnly =
    zio.aws.cloudformation.model.ManagedExecution.wrap(buildAwsValue())
}
object ManagedExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ManagedExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ManagedExecution =
      zio.aws.cloudformation.model.ManagedExecution(active.map(value => value))
    def active: Option[ManagedExecutionNullable]
    def getActive: ZIO[Any, AwsError, ManagedExecutionNullable] =
      AwsError.unwrapOptionField("active", active)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ManagedExecution
  ) extends zio.aws.cloudformation.model.ManagedExecution.ReadOnly {
    override val active: Option[ManagedExecutionNullable] = scala
      .Option(impl.active())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ManagedExecutionNullable(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ManagedExecution
  ): zio.aws.cloudformation.model.ManagedExecution.ReadOnly = new Wrapper(impl)
}
