package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.TemplateBody
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetTemplateResponse(
    templateBody: Option[TemplateBody] = None,
    stagesAvailable: Option[
      Iterable[zio.aws.cloudformation.model.TemplateStage]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.GetTemplateResponse = {
    import GetTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.GetTemplateResponse
      .builder()
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        stagesAvailable.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.stagesAvailableWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.GetTemplateResponse.ReadOnly =
    zio.aws.cloudformation.model.GetTemplateResponse.wrap(buildAwsValue())
}
object GetTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.GetTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.GetTemplateResponse =
      zio.aws.cloudformation.model.GetTemplateResponse(
        templateBody.map(value => value),
        stagesAvailable.map(value => value)
      )
    def templateBody: Option[TemplateBody]
    def stagesAvailable
        : Option[List[zio.aws.cloudformation.model.TemplateStage]]
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getStagesAvailable
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.TemplateStage]] =
      AwsError.unwrapOptionField("stagesAvailable", stagesAvailable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.GetTemplateResponse
  ) extends zio.aws.cloudformation.model.GetTemplateResponse.ReadOnly {
    override val templateBody: Option[TemplateBody] = scala
      .Option(impl.templateBody())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateBody(value))
    override val stagesAvailable
        : Option[List[zio.aws.cloudformation.model.TemplateStage]] = scala
      .Option(impl.stagesAvailable())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.TemplateStage.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.GetTemplateResponse
  ): zio.aws.cloudformation.model.GetTemplateResponse.ReadOnly = new Wrapper(
    impl
  )
}
