package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.PublisherId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribePublisherRequest(
    publisherId: Option[PublisherId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribePublisherRequest = {
    import DescribePublisherRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribePublisherRequest
      .builder()
      .optionallyWith(
        publisherId.map(value => PublisherId.unwrap(value): java.lang.String)
      )(_.publisherId)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribePublisherRequest.ReadOnly =
    zio.aws.cloudformation.model.DescribePublisherRequest.wrap(buildAwsValue())
}
object DescribePublisherRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribePublisherRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribePublisherRequest =
      zio.aws.cloudformation.model
        .DescribePublisherRequest(publisherId.map(value => value))
    def publisherId: Option[PublisherId]
    def getPublisherId: ZIO[Any, AwsError, PublisherId] =
      AwsError.unwrapOptionField("publisherId", publisherId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribePublisherRequest
  ) extends zio.aws.cloudformation.model.DescribePublisherRequest.ReadOnly {
    override val publisherId: Option[PublisherId] = scala
      .Option(impl.publisherId())
      .map(value => zio.aws.cloudformation.model.primitives.PublisherId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribePublisherRequest
  ): zio.aws.cloudformation.model.DescribePublisherRequest.ReadOnly =
    new Wrapper(impl)
}
