package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  LogicalResourceId,
  NextToken,
  StackNameOrId,
  ChangeSetNameOrId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeChangeSetHooksRequest(
    changeSetName: ChangeSetNameOrId,
    stackName: Option[StackNameOrId] = None,
    nextToken: Option[NextToken] = None,
    logicalResourceId: Option[LogicalResourceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksRequest = {
    import DescribeChangeSetHooksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksRequest
      .builder()
      .changeSetName(ChangeSetNameOrId.unwrap(changeSetName): java.lang.String)
      .optionallyWith(
        stackName.map(value => StackNameOrId.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        logicalResourceId.map(value =>
          LogicalResourceId.unwrap(value): java.lang.String
        )
      )(_.logicalResourceId)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeChangeSetHooksRequest.ReadOnly =
    zio.aws.cloudformation.model.DescribeChangeSetHooksRequest
      .wrap(buildAwsValue())
}
object DescribeChangeSetHooksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeChangeSetHooksRequest =
      zio.aws.cloudformation.model.DescribeChangeSetHooksRequest(
        changeSetName,
        stackName.map(value => value),
        nextToken.map(value => value),
        logicalResourceId.map(value => value)
      )
    def changeSetName: ChangeSetNameOrId
    def stackName: Option[StackNameOrId]
    def nextToken: Option[NextToken]
    def logicalResourceId: Option[LogicalResourceId]
    def getChangeSetName: ZIO[Any, Nothing, ChangeSetNameOrId] =
      ZIO.succeed(changeSetName)
    def getStackName: ZIO[Any, AwsError, StackNameOrId] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLogicalResourceId: ZIO[Any, AwsError, LogicalResourceId] =
      AwsError.unwrapOptionField("logicalResourceId", logicalResourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksRequest
  ) extends zio.aws.cloudformation.model.DescribeChangeSetHooksRequest.ReadOnly {
    override val changeSetName: ChangeSetNameOrId =
      zio.aws.cloudformation.model.primitives
        .ChangeSetNameOrId(impl.changeSetName())
    override val stackName: Option[StackNameOrId] = scala
      .Option(impl.stackName())
      .map(value =>
        zio.aws.cloudformation.model.primitives.StackNameOrId(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
    override val logicalResourceId: Option[LogicalResourceId] = scala
      .Option(impl.logicalResourceId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.LogicalResourceId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksRequest
  ): zio.aws.cloudformation.model.DescribeChangeSetHooksRequest.ReadOnly =
    new Wrapper(impl)
}
