package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  TypeVersionId,
  TypeName,
  PrivateTypeArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeregisterTypeRequest(
    arn: Option[PrivateTypeArn] = None,
    `type`: Option[zio.aws.cloudformation.model.RegistryType] = None,
    typeName: Option[TypeName] = None,
    versionId: Option[TypeVersionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DeregisterTypeRequest = {
    import DeregisterTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DeregisterTypeRequest
      .builder()
      .optionallyWith(
        arn.map(value => PrivateTypeArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        versionId.map(value => TypeVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.DeregisterTypeRequest.ReadOnly =
    zio.aws.cloudformation.model.DeregisterTypeRequest.wrap(buildAwsValue())
}
object DeregisterTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DeregisterTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DeregisterTypeRequest =
      zio.aws.cloudformation.model.DeregisterTypeRequest(
        arn.map(value => value),
        `type`.map(value => value),
        typeName.map(value => value),
        versionId.map(value => value)
      )
    def arn: Option[PrivateTypeArn]
    def `type`: Option[zio.aws.cloudformation.model.RegistryType]
    def typeName: Option[TypeName]
    def versionId: Option[TypeVersionId]
    def getArn: ZIO[Any, AwsError, PrivateTypeArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, zio.aws.cloudformation.model.RegistryType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getVersionId: ZIO[Any, AwsError, TypeVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DeregisterTypeRequest
  ) extends zio.aws.cloudformation.model.DeregisterTypeRequest.ReadOnly {
    override val arn: Option[PrivateTypeArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PrivateTypeArn(value)
      )
    override val `type`: Option[zio.aws.cloudformation.model.RegistryType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.cloudformation.model.RegistryType.wrap(value))
    override val typeName: Option[TypeName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val versionId: Option[TypeVersionId] = scala
      .Option(impl.versionId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TypeVersionId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DeregisterTypeRequest
  ): zio.aws.cloudformation.model.DeregisterTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
