package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  TemplateURL,
  StackSetName,
  ClientRequestToken,
  StackId,
  RoleARN,
  Description,
  ExecutionRoleName,
  TemplateBody
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateStackSetRequest(
    stackSetName: StackSetName,
    description: Option[Description] = None,
    templateBody: Option[TemplateBody] = None,
    templateURL: Option[TemplateURL] = None,
    stackId: Option[StackId] = None,
    parameters: Option[Iterable[zio.aws.cloudformation.model.Parameter]] = None,
    capabilities: Option[Iterable[zio.aws.cloudformation.model.Capability]] =
      None,
    tags: Option[Iterable[zio.aws.cloudformation.model.Tag]] = None,
    administrationRoleARN: Option[RoleARN] = None,
    executionRoleName: Option[ExecutionRoleName] = None,
    permissionModel: Option[zio.aws.cloudformation.model.PermissionModels] =
      None,
    autoDeployment: Option[zio.aws.cloudformation.model.AutoDeployment] = None,
    callAs: Option[zio.aws.cloudformation.model.CallAs] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    managedExecution: Option[zio.aws.cloudformation.model.ManagedExecution] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.CreateStackSetRequest = {
    import CreateStackSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.CreateStackSetRequest
      .builder()
      .stackSetName(StackSetName.unwrap(stackSetName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        templateURL.map(value => TemplateURL.unwrap(value): java.lang.String)
      )(_.templateURL)
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        administrationRoleARN.map(value =>
          RoleARN.unwrap(value): java.lang.String
        )
      )(_.administrationRoleARN)
      .optionallyWith(
        executionRoleName.map(value =>
          ExecutionRoleName.unwrap(value): java.lang.String
        )
      )(_.executionRoleName)
      .optionallyWith(permissionModel.map(value => value.unwrap))(
        _.permissionModel
      )
      .optionallyWith(autoDeployment.map(value => value.buildAwsValue()))(
        _.autoDeployment
      )
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(managedExecution.map(value => value.buildAwsValue()))(
        _.managedExecution
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.CreateStackSetRequest.ReadOnly =
    zio.aws.cloudformation.model.CreateStackSetRequest.wrap(buildAwsValue())
}
object CreateStackSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.CreateStackSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.CreateStackSetRequest =
      zio.aws.cloudformation.model.CreateStackSetRequest(
        stackSetName,
        description.map(value => value),
        templateBody.map(value => value),
        templateURL.map(value => value),
        stackId.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        capabilities.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        administrationRoleARN.map(value => value),
        executionRoleName.map(value => value),
        permissionModel.map(value => value),
        autoDeployment.map(value => value.asEditable),
        callAs.map(value => value),
        clientRequestToken.map(value => value),
        managedExecution.map(value => value.asEditable)
      )
    def stackSetName: StackSetName
    def description: Option[Description]
    def templateBody: Option[TemplateBody]
    def templateURL: Option[TemplateURL]
    def stackId: Option[StackId]
    def parameters
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def capabilities: Option[List[zio.aws.cloudformation.model.Capability]]
    def tags: Option[List[zio.aws.cloudformation.model.Tag.ReadOnly]]
    def administrationRoleARN: Option[RoleARN]
    def executionRoleName: Option[ExecutionRoleName]
    def permissionModel: Option[zio.aws.cloudformation.model.PermissionModels]
    def autoDeployment
        : Option[zio.aws.cloudformation.model.AutoDeployment.ReadOnly]
    def callAs: Option[zio.aws.cloudformation.model.CallAs]
    def clientRequestToken: Option[ClientRequestToken]
    def managedExecution
        : Option[zio.aws.cloudformation.model.ManagedExecution.ReadOnly]
    def getStackSetName: ZIO[Any, Nothing, StackSetName] =
      ZIO.succeed(stackSetName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getTemplateURL: ZIO[Any, AwsError, TemplateURL] =
      AwsError.unwrapOptionField("templateURL", templateURL)
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Capability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAdministrationRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("administrationRoleARN", administrationRoleARN)
    def getExecutionRoleName: ZIO[Any, AwsError, ExecutionRoleName] =
      AwsError.unwrapOptionField("executionRoleName", executionRoleName)
    def getPermissionModel
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.PermissionModels] =
      AwsError.unwrapOptionField("permissionModel", permissionModel)
    def getAutoDeployment: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.AutoDeployment.ReadOnly
    ] = AwsError.unwrapOptionField("autoDeployment", autoDeployment)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getManagedExecution: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.ManagedExecution.ReadOnly
    ] = AwsError.unwrapOptionField("managedExecution", managedExecution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.CreateStackSetRequest
  ) extends zio.aws.cloudformation.model.CreateStackSetRequest.ReadOnly {
    override val stackSetName: StackSetName =
      zio.aws.cloudformation.model.primitives.StackSetName(impl.stackSetName())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val templateBody: Option[TemplateBody] = scala
      .Option(impl.templateBody())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateBody(value))
    override val templateURL: Option[TemplateURL] = scala
      .Option(impl.templateURL())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateURL(value))
    override val stackId: Option[StackId] = scala
      .Option(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val parameters
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Parameter.wrap(item)
        }.toList
      )
    override val capabilities
        : Option[List[zio.aws.cloudformation.model.Capability]] = scala
      .Option(impl.capabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Capability.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Tag.wrap(item)
          }.toList
        )
    override val administrationRoleARN: Option[RoleARN] = scala
      .Option(impl.administrationRoleARN())
      .map(value => zio.aws.cloudformation.model.primitives.RoleARN(value))
    override val executionRoleName: Option[ExecutionRoleName] = scala
      .Option(impl.executionRoleName())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ExecutionRoleName(value)
      )
    override val permissionModel
        : Option[zio.aws.cloudformation.model.PermissionModels] = scala
      .Option(impl.permissionModel())
      .map(value => zio.aws.cloudformation.model.PermissionModels.wrap(value))
    override val autoDeployment
        : Option[zio.aws.cloudformation.model.AutoDeployment.ReadOnly] = scala
      .Option(impl.autoDeployment())
      .map(value => zio.aws.cloudformation.model.AutoDeployment.wrap(value))
    override val callAs: Option[zio.aws.cloudformation.model.CallAs] = scala
      .Option(impl.callAs())
      .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
      )
    override val managedExecution
        : Option[zio.aws.cloudformation.model.ManagedExecution.ReadOnly] = scala
      .Option(impl.managedExecution())
      .map(value => zio.aws.cloudformation.model.ManagedExecution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.CreateStackSetRequest
  ): zio.aws.cloudformation.model.CreateStackSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
