package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{StackId, ChangeSetId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateChangeSetResponse(
    id: Option[ChangeSetId] = None,
    stackId: Option[StackId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.CreateChangeSetResponse = {
    import CreateChangeSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.CreateChangeSetResponse
      .builder()
      .optionallyWith(
        id.map(value => ChangeSetId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.CreateChangeSetResponse.ReadOnly =
    zio.aws.cloudformation.model.CreateChangeSetResponse.wrap(buildAwsValue())
}
object CreateChangeSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.CreateChangeSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.CreateChangeSetResponse =
      zio.aws.cloudformation.model.CreateChangeSetResponse(
        id.map(value => value),
        stackId.map(value => value)
      )
    def id: Option[ChangeSetId]
    def stackId: Option[StackId]
    def getId: ZIO[Any, AwsError, ChangeSetId] =
      AwsError.unwrapOptionField("id", id)
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.CreateChangeSetResponse
  ) extends zio.aws.cloudformation.model.CreateChangeSetResponse.ReadOnly {
    override val id: Option[ChangeSetId] = scala
      .Option(impl.id())
      .map(value => zio.aws.cloudformation.model.primitives.ChangeSetId(value))
    override val stackId: Option[StackId] = scala
      .Option(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.CreateChangeSetResponse
  ): zio.aws.cloudformation.model.CreateChangeSetResponse.ReadOnly =
    new Wrapper(impl)
}
