package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  Account,
  TemplateURL,
  StackSetName,
  ClientRequestToken,
  UsePreviousTemplate,
  RoleARN,
  Description,
  Region,
  ExecutionRoleName,
  TemplateBody
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateStackSetRequest(
    stackSetName: StackSetName,
    description: Option[Description] = None,
    templateBody: Option[TemplateBody] = None,
    templateURL: Option[TemplateURL] = None,
    usePreviousTemplate: Option[UsePreviousTemplate] = None,
    parameters: Option[Iterable[zio.aws.cloudformation.model.Parameter]] = None,
    capabilities: Option[Iterable[zio.aws.cloudformation.model.Capability]] =
      None,
    tags: Option[Iterable[zio.aws.cloudformation.model.Tag]] = None,
    operationPreferences: Option[
      zio.aws.cloudformation.model.StackSetOperationPreferences
    ] = None,
    administrationRoleARN: Option[RoleARN] = None,
    executionRoleName: Option[ExecutionRoleName] = None,
    deploymentTargets: Option[zio.aws.cloudformation.model.DeploymentTargets] =
      None,
    permissionModel: Option[zio.aws.cloudformation.model.PermissionModels] =
      None,
    autoDeployment: Option[zio.aws.cloudformation.model.AutoDeployment] = None,
    operationId: Option[ClientRequestToken] = None,
    accounts: Option[Iterable[Account]] = None,
    regions: Option[Iterable[Region]] = None,
    callAs: Option[zio.aws.cloudformation.model.CallAs] = None,
    managedExecution: Option[zio.aws.cloudformation.model.ManagedExecution] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest = {
    import UpdateStackSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest
      .builder()
      .stackSetName(StackSetName.unwrap(stackSetName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        templateURL.map(value => TemplateURL.unwrap(value): java.lang.String)
      )(_.templateURL)
      .optionallyWith(
        usePreviousTemplate.map(value =>
          UsePreviousTemplate.unwrap(value): java.lang.Boolean
        )
      )(_.usePreviousTemplate)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(operationPreferences.map(value => value.buildAwsValue()))(
        _.operationPreferences
      )
      .optionallyWith(
        administrationRoleARN.map(value =>
          RoleARN.unwrap(value): java.lang.String
        )
      )(_.administrationRoleARN)
      .optionallyWith(
        executionRoleName.map(value =>
          ExecutionRoleName.unwrap(value): java.lang.String
        )
      )(_.executionRoleName)
      .optionallyWith(deploymentTargets.map(value => value.buildAwsValue()))(
        _.deploymentTargets
      )
      .optionallyWith(permissionModel.map(value => value.unwrap))(
        _.permissionModel
      )
      .optionallyWith(autoDeployment.map(value => value.buildAwsValue()))(
        _.autoDeployment
      )
      .optionallyWith(
        operationId.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.operationId)
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            Account.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accounts)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            Region.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .optionallyWith(managedExecution.map(value => value.buildAwsValue()))(
        _.managedExecution
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.UpdateStackSetRequest.ReadOnly =
    zio.aws.cloudformation.model.UpdateStackSetRequest.wrap(buildAwsValue())
}
object UpdateStackSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.UpdateStackSetRequest =
      zio.aws.cloudformation.model.UpdateStackSetRequest(
        stackSetName,
        description.map(value => value),
        templateBody.map(value => value),
        templateURL.map(value => value),
        usePreviousTemplate.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        capabilities.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        operationPreferences.map(value => value.asEditable),
        administrationRoleARN.map(value => value),
        executionRoleName.map(value => value),
        deploymentTargets.map(value => value.asEditable),
        permissionModel.map(value => value),
        autoDeployment.map(value => value.asEditable),
        operationId.map(value => value),
        accounts.map(value => value),
        regions.map(value => value),
        callAs.map(value => value),
        managedExecution.map(value => value.asEditable)
      )
    def stackSetName: StackSetName
    def description: Option[Description]
    def templateBody: Option[TemplateBody]
    def templateURL: Option[TemplateURL]
    def usePreviousTemplate: Option[UsePreviousTemplate]
    def parameters
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def capabilities: Option[List[zio.aws.cloudformation.model.Capability]]
    def tags: Option[List[zio.aws.cloudformation.model.Tag.ReadOnly]]
    def operationPreferences: Option[
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ]
    def administrationRoleARN: Option[RoleARN]
    def executionRoleName: Option[ExecutionRoleName]
    def deploymentTargets
        : Option[zio.aws.cloudformation.model.DeploymentTargets.ReadOnly]
    def permissionModel: Option[zio.aws.cloudformation.model.PermissionModels]
    def autoDeployment
        : Option[zio.aws.cloudformation.model.AutoDeployment.ReadOnly]
    def operationId: Option[ClientRequestToken]
    def accounts: Option[List[Account]]
    def regions: Option[List[Region]]
    def callAs: Option[zio.aws.cloudformation.model.CallAs]
    def managedExecution
        : Option[zio.aws.cloudformation.model.ManagedExecution.ReadOnly]
    def getStackSetName: ZIO[Any, Nothing, StackSetName] =
      ZIO.succeed(stackSetName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getTemplateURL: ZIO[Any, AwsError, TemplateURL] =
      AwsError.unwrapOptionField("templateURL", templateURL)
    def getUsePreviousTemplate: ZIO[Any, AwsError, UsePreviousTemplate] =
      AwsError.unwrapOptionField("usePreviousTemplate", usePreviousTemplate)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Capability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getOperationPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField("operationPreferences", operationPreferences)
    def getAdministrationRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("administrationRoleARN", administrationRoleARN)
    def getExecutionRoleName: ZIO[Any, AwsError, ExecutionRoleName] =
      AwsError.unwrapOptionField("executionRoleName", executionRoleName)
    def getDeploymentTargets: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.DeploymentTargets.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentTargets", deploymentTargets)
    def getPermissionModel
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.PermissionModels] =
      AwsError.unwrapOptionField("permissionModel", permissionModel)
    def getAutoDeployment: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.AutoDeployment.ReadOnly
    ] = AwsError.unwrapOptionField("autoDeployment", autoDeployment)
    def getOperationId: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("operationId", operationId)
    def getAccounts: ZIO[Any, AwsError, List[Account]] =
      AwsError.unwrapOptionField("accounts", accounts)
    def getRegions: ZIO[Any, AwsError, List[Region]] =
      AwsError.unwrapOptionField("regions", regions)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
    def getManagedExecution: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.ManagedExecution.ReadOnly
    ] = AwsError.unwrapOptionField("managedExecution", managedExecution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest
  ) extends zio.aws.cloudformation.model.UpdateStackSetRequest.ReadOnly {
    override val stackSetName: StackSetName =
      zio.aws.cloudformation.model.primitives.StackSetName(impl.stackSetName())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val templateBody: Option[TemplateBody] = scala
      .Option(impl.templateBody())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateBody(value))
    override val templateURL: Option[TemplateURL] = scala
      .Option(impl.templateURL())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateURL(value))
    override val usePreviousTemplate: Option[UsePreviousTemplate] = scala
      .Option(impl.usePreviousTemplate())
      .map(value =>
        zio.aws.cloudformation.model.primitives.UsePreviousTemplate(value)
      )
    override val parameters
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Parameter.wrap(item)
        }.toList
      )
    override val capabilities
        : Option[List[zio.aws.cloudformation.model.Capability]] = scala
      .Option(impl.capabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Capability.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Tag.wrap(item)
          }.toList
        )
    override val operationPreferences: Option[
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ] = scala
      .Option(impl.operationPreferences())
      .map(value =>
        zio.aws.cloudformation.model.StackSetOperationPreferences.wrap(value)
      )
    override val administrationRoleARN: Option[RoleARN] = scala
      .Option(impl.administrationRoleARN())
      .map(value => zio.aws.cloudformation.model.primitives.RoleARN(value))
    override val executionRoleName: Option[ExecutionRoleName] = scala
      .Option(impl.executionRoleName())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ExecutionRoleName(value)
      )
    override val deploymentTargets
        : Option[zio.aws.cloudformation.model.DeploymentTargets.ReadOnly] =
      scala
        .Option(impl.deploymentTargets())
        .map(value =>
          zio.aws.cloudformation.model.DeploymentTargets.wrap(value)
        )
    override val permissionModel
        : Option[zio.aws.cloudformation.model.PermissionModels] = scala
      .Option(impl.permissionModel())
      .map(value => zio.aws.cloudformation.model.PermissionModels.wrap(value))
    override val autoDeployment
        : Option[zio.aws.cloudformation.model.AutoDeployment.ReadOnly] = scala
      .Option(impl.autoDeployment())
      .map(value => zio.aws.cloudformation.model.AutoDeployment.wrap(value))
    override val operationId: Option[ClientRequestToken] = scala
      .Option(impl.operationId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
      )
    override val accounts: Option[List[Account]] = scala
      .Option(impl.accounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.Account(item)
        }.toList
      )
    override val regions: Option[List[Region]] = scala
      .Option(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.Region(item)
        }.toList
      )
    override val callAs: Option[zio.aws.cloudformation.model.CallAs] = scala
      .Option(impl.callAs())
      .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
    override val managedExecution
        : Option[zio.aws.cloudformation.model.ManagedExecution.ReadOnly] = scala
      .Option(impl.managedExecution())
      .map(value => zio.aws.cloudformation.model.ManagedExecution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest
  ): zio.aws.cloudformation.model.UpdateStackSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
