package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  CreationTime,
  StackName,
  DeletionTime,
  TemplateDescription,
  StackId,
  LastUpdatedTime,
  StackStatusReason
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StackSummary(
    stackId: Option[StackId] = None,
    stackName: StackName,
    templateDescription: Option[TemplateDescription] = None,
    creationTime: CreationTime,
    lastUpdatedTime: Option[LastUpdatedTime] = None,
    deletionTime: Option[DeletionTime] = None,
    stackStatus: zio.aws.cloudformation.model.StackStatus,
    stackStatusReason: Option[StackStatusReason] = None,
    parentId: Option[StackId] = None,
    rootId: Option[StackId] = None,
    driftInformation: Option[
      zio.aws.cloudformation.model.StackDriftInformationSummary
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackSummary = {
    import StackSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackSummary
      .builder()
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .stackName(StackName.unwrap(stackName): java.lang.String)
      .optionallyWith(
        templateDescription.map(value =>
          TemplateDescription.unwrap(value): java.lang.String
        )
      )(_.templateDescription)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .optionallyWith(
        lastUpdatedTime.map(value => LastUpdatedTime.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        deletionTime.map(value => DeletionTime.unwrap(value): Instant)
      )(_.deletionTime)
      .stackStatus(stackStatus.unwrap)
      .optionallyWith(
        stackStatusReason.map(value =>
          StackStatusReason.unwrap(value): java.lang.String
        )
      )(_.stackStatusReason)
      .optionallyWith(
        parentId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.parentId)
      .optionallyWith(
        rootId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.rootId)
      .optionallyWith(driftInformation.map(value => value.buildAwsValue()))(
        _.driftInformation
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.StackSummary.ReadOnly =
    zio.aws.cloudformation.model.StackSummary.wrap(buildAwsValue())
}
object StackSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackSummary =
      zio.aws.cloudformation.model.StackSummary(
        stackId.map(value => value),
        stackName,
        templateDescription.map(value => value),
        creationTime,
        lastUpdatedTime.map(value => value),
        deletionTime.map(value => value),
        stackStatus,
        stackStatusReason.map(value => value),
        parentId.map(value => value),
        rootId.map(value => value),
        driftInformation.map(value => value.asEditable)
      )
    def stackId: Option[StackId]
    def stackName: StackName
    def templateDescription: Option[TemplateDescription]
    def creationTime: CreationTime
    def lastUpdatedTime: Option[LastUpdatedTime]
    def deletionTime: Option[DeletionTime]
    def stackStatus: zio.aws.cloudformation.model.StackStatus
    def stackStatusReason: Option[StackStatusReason]
    def parentId: Option[StackId]
    def rootId: Option[StackId]
    def driftInformation: Option[
      zio.aws.cloudformation.model.StackDriftInformationSummary.ReadOnly
    ]
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
    def getStackName: ZIO[Any, Nothing, StackName] = ZIO.succeed(stackName)
    def getTemplateDescription: ZIO[Any, AwsError, TemplateDescription] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, LastUpdatedTime] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getDeletionTime: ZIO[Any, AwsError, DeletionTime] =
      AwsError.unwrapOptionField("deletionTime", deletionTime)
    def getStackStatus
        : ZIO[Any, Nothing, zio.aws.cloudformation.model.StackStatus] =
      ZIO.succeed(stackStatus)
    def getStackStatusReason: ZIO[Any, AwsError, StackStatusReason] =
      AwsError.unwrapOptionField("stackStatusReason", stackStatusReason)
    def getParentId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("parentId", parentId)
    def getRootId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("rootId", rootId)
    def getDriftInformation: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackDriftInformationSummary.ReadOnly
    ] = AwsError.unwrapOptionField("driftInformation", driftInformation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSummary
  ) extends zio.aws.cloudformation.model.StackSummary.ReadOnly {
    override val stackId: Option[StackId] = scala
      .Option(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val stackName: StackName =
      zio.aws.cloudformation.model.primitives.StackName(impl.stackName())
    override val templateDescription: Option[TemplateDescription] = scala
      .Option(impl.templateDescription())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TemplateDescription(value)
      )
    override val creationTime: CreationTime =
      zio.aws.cloudformation.model.primitives.CreationTime(impl.creationTime())
    override val lastUpdatedTime: Option[LastUpdatedTime] = scala
      .Option(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.cloudformation.model.primitives.LastUpdatedTime(value)
      )
    override val deletionTime: Option[DeletionTime] = scala
      .Option(impl.deletionTime())
      .map(value => zio.aws.cloudformation.model.primitives.DeletionTime(value))
    override val stackStatus: zio.aws.cloudformation.model.StackStatus =
      zio.aws.cloudformation.model.StackStatus.wrap(impl.stackStatus())
    override val stackStatusReason: Option[StackStatusReason] = scala
      .Option(impl.stackStatusReason())
      .map(value =>
        zio.aws.cloudformation.model.primitives.StackStatusReason(value)
      )
    override val parentId: Option[StackId] = scala
      .Option(impl.parentId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val rootId: Option[StackId] = scala
      .Option(impl.rootId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val driftInformation: Option[
      zio.aws.cloudformation.model.StackDriftInformationSummary.ReadOnly
    ] = scala
      .Option(impl.driftInformation())
      .map(value =>
        zio.aws.cloudformation.model.StackDriftInformationSummary.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSummary
  ): zio.aws.cloudformation.model.StackSummary.ReadOnly = new Wrapper(impl)
}
