package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ClientRequestToken,
  ResourceModel,
  StatusMessage,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RecordHandlerProgressRequest(
    bearerToken: ClientToken,
    operationStatus: zio.aws.cloudformation.model.OperationStatus,
    currentOperationStatus: Option[
      zio.aws.cloudformation.model.OperationStatus
    ] = None,
    statusMessage: Option[StatusMessage] = None,
    errorCode: Option[zio.aws.cloudformation.model.HandlerErrorCode] = None,
    resourceModel: Option[ResourceModel] = None,
    clientRequestToken: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest = {
    import RecordHandlerProgressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest
      .builder()
      .bearerToken(ClientToken.unwrap(bearerToken): java.lang.String)
      .operationStatus(operationStatus.unwrap)
      .optionallyWith(currentOperationStatus.map(value => value.unwrap))(
        _.currentOperationStatus
      )
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        resourceModel.map(value =>
          ResourceModel.unwrap(value): java.lang.String
        )
      )(_.resourceModel)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.RecordHandlerProgressRequest.ReadOnly =
    zio.aws.cloudformation.model.RecordHandlerProgressRequest
      .wrap(buildAwsValue())
}
object RecordHandlerProgressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.RecordHandlerProgressRequest =
      zio.aws.cloudformation.model.RecordHandlerProgressRequest(
        bearerToken,
        operationStatus,
        currentOperationStatus.map(value => value),
        statusMessage.map(value => value),
        errorCode.map(value => value),
        resourceModel.map(value => value),
        clientRequestToken.map(value => value)
      )
    def bearerToken: ClientToken
    def operationStatus: zio.aws.cloudformation.model.OperationStatus
    def currentOperationStatus
        : Option[zio.aws.cloudformation.model.OperationStatus]
    def statusMessage: Option[StatusMessage]
    def errorCode: Option[zio.aws.cloudformation.model.HandlerErrorCode]
    def resourceModel: Option[ResourceModel]
    def clientRequestToken: Option[ClientRequestToken]
    def getBearerToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(bearerToken)
    def getOperationStatus
        : ZIO[Any, Nothing, zio.aws.cloudformation.model.OperationStatus] =
      ZIO.succeed(operationStatus)
    def getCurrentOperationStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.OperationStatus] =
      AwsError.unwrapOptionField(
        "currentOperationStatus",
        currentOperationStatus
      )
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.HandlerErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getResourceModel: ZIO[Any, AwsError, ResourceModel] =
      AwsError.unwrapOptionField("resourceModel", resourceModel)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest
  ) extends zio.aws.cloudformation.model.RecordHandlerProgressRequest.ReadOnly {
    override val bearerToken: ClientToken =
      zio.aws.cloudformation.model.primitives.ClientToken(impl.bearerToken())
    override val operationStatus: zio.aws.cloudformation.model.OperationStatus =
      zio.aws.cloudformation.model.OperationStatus.wrap(impl.operationStatus())
    override val currentOperationStatus
        : Option[zio.aws.cloudformation.model.OperationStatus] = scala
      .Option(impl.currentOperationStatus())
      .map(value => zio.aws.cloudformation.model.OperationStatus.wrap(value))
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.cloudformation.model.primitives.StatusMessage(value)
      )
    override val errorCode
        : Option[zio.aws.cloudformation.model.HandlerErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.cloudformation.model.HandlerErrorCode.wrap(value))
    override val resourceModel: Option[ResourceModel] = scala
      .Option(impl.resourceModel())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ResourceModel(value)
      )
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest
  ): zio.aws.cloudformation.model.RecordHandlerProgressRequest.ReadOnly =
    new Wrapper(impl)
}
