package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{NextToken, RegistrationToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTypeRegistrationsResponse(
    registrationTokenList: Option[Iterable[RegistrationToken]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse = {
    import ListTypeRegistrationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse
      .builder()
      .optionallyWith(
        registrationTokenList.map(value =>
          value.map { item =>
            RegistrationToken.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.registrationTokenList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ListTypeRegistrationsResponse.ReadOnly =
    zio.aws.cloudformation.model.ListTypeRegistrationsResponse
      .wrap(buildAwsValue())
}
object ListTypeRegistrationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListTypeRegistrationsResponse =
      zio.aws.cloudformation.model.ListTypeRegistrationsResponse(
        registrationTokenList.map(value => value),
        nextToken.map(value => value)
      )
    def registrationTokenList: Option[List[RegistrationToken]]
    def nextToken: Option[NextToken]
    def getRegistrationTokenList: ZIO[Any, AwsError, List[RegistrationToken]] =
      AwsError.unwrapOptionField("registrationTokenList", registrationTokenList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse
  ) extends zio.aws.cloudformation.model.ListTypeRegistrationsResponse.ReadOnly {
    override val registrationTokenList: Option[List[RegistrationToken]] = scala
      .Option(impl.registrationTokenList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.RegistrationToken(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse
  ): zio.aws.cloudformation.model.ListTypeRegistrationsResponse.ReadOnly =
    new Wrapper(impl)
}
