package zio.aws.cloudformation.model
import java.lang.Integer
import zio.aws.cloudformation.model.primitives.{MaxResults, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListStackSetsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    status: Option[zio.aws.cloudformation.model.StackSetStatus] = None,
    callAs: Option[zio.aws.cloudformation.model.CallAs] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest = {
    import ListStackSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ListStackSetsRequest.ReadOnly =
    zio.aws.cloudformation.model.ListStackSetsRequest.wrap(buildAwsValue())
}
object ListStackSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListStackSetsRequest =
      zio.aws.cloudformation.model.ListStackSetsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        status.map(value => value),
        callAs.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def status: Option[zio.aws.cloudformation.model.StackSetStatus]
    def callAs: Option[zio.aws.cloudformation.model.CallAs]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.StackSetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest
  ) extends zio.aws.cloudformation.model.ListStackSetsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.cloudformation.model.primitives.MaxResults(value))
    override val status: Option[zio.aws.cloudformation.model.StackSetStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.cloudformation.model.StackSetStatus.wrap(value))
    override val callAs: Option[zio.aws.cloudformation.model.CallAs] = scala
      .Option(impl.callAs())
      .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest
  ): zio.aws.cloudformation.model.ListStackSetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
