package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListStackResourcesResponse(
    stackResourceSummaries: Option[
      Iterable[zio.aws.cloudformation.model.StackResourceSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse = {
    import ListStackResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse
      .builder()
      .optionallyWith(
        stackResourceSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stackResourceSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ListStackResourcesResponse.ReadOnly =
    zio.aws.cloudformation.model.ListStackResourcesResponse
      .wrap(buildAwsValue())
}
object ListStackResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListStackResourcesResponse =
      zio.aws.cloudformation.model.ListStackResourcesResponse(
        stackResourceSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def stackResourceSummaries: Option[
      List[zio.aws.cloudformation.model.StackResourceSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getStackResourceSummaries: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.StackResourceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "stackResourceSummaries",
      stackResourceSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse
  ) extends zio.aws.cloudformation.model.ListStackResourcesResponse.ReadOnly {
    override val stackResourceSummaries: Option[
      List[zio.aws.cloudformation.model.StackResourceSummary.ReadOnly]
    ] = scala
      .Option(impl.stackResourceSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.StackResourceSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse
  ): zio.aws.cloudformation.model.ListStackResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
