package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ClientRequestToken,
  StackSetNameOrId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DetectStackSetDriftRequest(
    stackSetName: StackSetNameOrId,
    operationPreferences: Option[
      zio.aws.cloudformation.model.StackSetOperationPreferences
    ] = None,
    operationId: Option[ClientRequestToken] = None,
    callAs: Option[zio.aws.cloudformation.model.CallAs] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftRequest = {
    import DetectStackSetDriftRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftRequest
      .builder()
      .stackSetName(StackSetNameOrId.unwrap(stackSetName): java.lang.String)
      .optionallyWith(operationPreferences.map(value => value.buildAwsValue()))(
        _.operationPreferences
      )
      .optionallyWith(
        operationId.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.operationId)
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DetectStackSetDriftRequest.ReadOnly =
    zio.aws.cloudformation.model.DetectStackSetDriftRequest
      .wrap(buildAwsValue())
}
object DetectStackSetDriftRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DetectStackSetDriftRequest =
      zio.aws.cloudformation.model.DetectStackSetDriftRequest(
        stackSetName,
        operationPreferences.map(value => value.asEditable),
        operationId.map(value => value),
        callAs.map(value => value)
      )
    def stackSetName: StackSetNameOrId
    def operationPreferences: Option[
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ]
    def operationId: Option[ClientRequestToken]
    def callAs: Option[zio.aws.cloudformation.model.CallAs]
    def getStackSetName: ZIO[Any, Nothing, StackSetNameOrId] =
      ZIO.succeed(stackSetName)
    def getOperationPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField("operationPreferences", operationPreferences)
    def getOperationId: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("operationId", operationId)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftRequest
  ) extends zio.aws.cloudformation.model.DetectStackSetDriftRequest.ReadOnly {
    override val stackSetName: StackSetNameOrId =
      zio.aws.cloudformation.model.primitives
        .StackSetNameOrId(impl.stackSetName())
    override val operationPreferences: Option[
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ] = scala
      .Option(impl.operationPreferences())
      .map(value =>
        zio.aws.cloudformation.model.StackSetOperationPreferences.wrap(value)
      )
    override val operationId: Option[ClientRequestToken] = scala
      .Option(impl.operationId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
      )
    override val callAs: Option[zio.aws.cloudformation.model.CallAs] = scala
      .Option(impl.callAs())
      .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftRequest
  ): zio.aws.cloudformation.model.DetectStackSetDriftRequest.ReadOnly =
    new Wrapper(impl)
}
