package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  StackNameOrId,
  ChangeSetName,
  TemplateURL,
  NotificationARN,
  IncludeNestedStacks,
  UsePreviousTemplate,
  ResourceType,
  RoleARN,
  Description,
  ClientToken,
  TemplateBody
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateChangeSetRequest(
    stackName: StackNameOrId,
    templateBody: Option[TemplateBody] = None,
    templateURL: Option[TemplateURL] = None,
    usePreviousTemplate: Option[UsePreviousTemplate] = None,
    parameters: Option[Iterable[zio.aws.cloudformation.model.Parameter]] = None,
    capabilities: Option[Iterable[zio.aws.cloudformation.model.Capability]] =
      None,
    resourceTypes: Option[Iterable[ResourceType]] = None,
    roleARN: Option[RoleARN] = None,
    rollbackConfiguration: Option[
      zio.aws.cloudformation.model.RollbackConfiguration
    ] = None,
    notificationARNs: Option[Iterable[NotificationARN]] = None,
    tags: Option[Iterable[zio.aws.cloudformation.model.Tag]] = None,
    changeSetName: ChangeSetName,
    clientToken: Option[ClientToken] = None,
    description: Option[Description] = None,
    changeSetType: Option[zio.aws.cloudformation.model.ChangeSetType] = None,
    resourcesToImport: Option[
      Iterable[zio.aws.cloudformation.model.ResourceToImport]
    ] = None,
    includeNestedStacks: Option[IncludeNestedStacks] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest = {
    import CreateChangeSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest
      .builder()
      .stackName(StackNameOrId.unwrap(stackName): java.lang.String)
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        templateURL.map(value => TemplateURL.unwrap(value): java.lang.String)
      )(_.templateURL)
      .optionallyWith(
        usePreviousTemplate.map(value =>
          UsePreviousTemplate.unwrap(value): java.lang.Boolean
        )
      )(_.usePreviousTemplate)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            ResourceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        rollbackConfiguration.map(value => value.buildAwsValue())
      )(_.rollbackConfiguration)
      .optionallyWith(
        notificationARNs.map(value =>
          value.map { item =>
            NotificationARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.notificationARNs)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .changeSetName(ChangeSetName.unwrap(changeSetName): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(changeSetType.map(value => value.unwrap))(_.changeSetType)
      .optionallyWith(
        resourcesToImport.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourcesToImport)
      .optionallyWith(
        includeNestedStacks.map(value =>
          IncludeNestedStacks.unwrap(value): java.lang.Boolean
        )
      )(_.includeNestedStacks)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.CreateChangeSetRequest.ReadOnly =
    zio.aws.cloudformation.model.CreateChangeSetRequest.wrap(buildAwsValue())
}
object CreateChangeSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.CreateChangeSetRequest =
      zio.aws.cloudformation.model.CreateChangeSetRequest(
        stackName,
        templateBody.map(value => value),
        templateURL.map(value => value),
        usePreviousTemplate.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        capabilities.map(value => value),
        resourceTypes.map(value => value),
        roleARN.map(value => value),
        rollbackConfiguration.map(value => value.asEditable),
        notificationARNs.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        changeSetName,
        clientToken.map(value => value),
        description.map(value => value),
        changeSetType.map(value => value),
        resourcesToImport.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        includeNestedStacks.map(value => value)
      )
    def stackName: StackNameOrId
    def templateBody: Option[TemplateBody]
    def templateURL: Option[TemplateURL]
    def usePreviousTemplate: Option[UsePreviousTemplate]
    def parameters
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def capabilities: Option[List[zio.aws.cloudformation.model.Capability]]
    def resourceTypes: Option[List[ResourceType]]
    def roleARN: Option[RoleARN]
    def rollbackConfiguration
        : Option[zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly]
    def notificationARNs: Option[List[NotificationARN]]
    def tags: Option[List[zio.aws.cloudformation.model.Tag.ReadOnly]]
    def changeSetName: ChangeSetName
    def clientToken: Option[ClientToken]
    def description: Option[Description]
    def changeSetType: Option[zio.aws.cloudformation.model.ChangeSetType]
    def resourcesToImport
        : Option[List[zio.aws.cloudformation.model.ResourceToImport.ReadOnly]]
    def includeNestedStacks: Option[IncludeNestedStacks]
    def getStackName: ZIO[Any, Nothing, StackNameOrId] = ZIO.succeed(stackName)
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getTemplateURL: ZIO[Any, AwsError, TemplateURL] =
      AwsError.unwrapOptionField("templateURL", templateURL)
    def getUsePreviousTemplate: ZIO[Any, AwsError, UsePreviousTemplate] =
      AwsError.unwrapOptionField("usePreviousTemplate", usePreviousTemplate)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Capability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getResourceTypes: ZIO[Any, AwsError, List[ResourceType]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getRollbackConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("rollbackConfiguration", rollbackConfiguration)
    def getNotificationARNs: ZIO[Any, AwsError, List[NotificationARN]] =
      AwsError.unwrapOptionField("notificationARNs", notificationARNs)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getChangeSetName: ZIO[Any, Nothing, ChangeSetName] =
      ZIO.succeed(changeSetName)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getChangeSetType
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ChangeSetType] =
      AwsError.unwrapOptionField("changeSetType", changeSetType)
    def getResourcesToImport: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.ResourceToImport.ReadOnly
    ]] = AwsError.unwrapOptionField("resourcesToImport", resourcesToImport)
    def getIncludeNestedStacks: ZIO[Any, AwsError, IncludeNestedStacks] =
      AwsError.unwrapOptionField("includeNestedStacks", includeNestedStacks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest
  ) extends zio.aws.cloudformation.model.CreateChangeSetRequest.ReadOnly {
    override val stackName: StackNameOrId =
      zio.aws.cloudformation.model.primitives.StackNameOrId(impl.stackName())
    override val templateBody: Option[TemplateBody] = scala
      .Option(impl.templateBody())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateBody(value))
    override val templateURL: Option[TemplateURL] = scala
      .Option(impl.templateURL())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateURL(value))
    override val usePreviousTemplate: Option[UsePreviousTemplate] = scala
      .Option(impl.usePreviousTemplate())
      .map(value =>
        zio.aws.cloudformation.model.primitives.UsePreviousTemplate(value)
      )
    override val parameters
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Parameter.wrap(item)
        }.toList
      )
    override val capabilities
        : Option[List[zio.aws.cloudformation.model.Capability]] = scala
      .Option(impl.capabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Capability.wrap(item)
        }.toList
      )
    override val resourceTypes: Option[List[ResourceType]] = scala
      .Option(impl.resourceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.ResourceType(item)
        }.toList
      )
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.cloudformation.model.primitives.RoleARN(value))
    override val rollbackConfiguration
        : Option[zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly] =
      scala
        .Option(impl.rollbackConfiguration())
        .map(value =>
          zio.aws.cloudformation.model.RollbackConfiguration.wrap(value)
        )
    override val notificationARNs: Option[List[NotificationARN]] = scala
      .Option(impl.notificationARNs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.NotificationARN(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Tag.wrap(item)
          }.toList
        )
    override val changeSetName: ChangeSetName =
      zio.aws.cloudformation.model.primitives
        .ChangeSetName(impl.changeSetName())
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.cloudformation.model.primitives.ClientToken(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val changeSetType
        : Option[zio.aws.cloudformation.model.ChangeSetType] = scala
      .Option(impl.changeSetType())
      .map(value => zio.aws.cloudformation.model.ChangeSetType.wrap(value))
    override val resourcesToImport
        : Option[List[zio.aws.cloudformation.model.ResourceToImport.ReadOnly]] =
      scala
        .Option(impl.resourcesToImport())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.ResourceToImport.wrap(item)
          }.toList
        )
    override val includeNestedStacks: Option[IncludeNestedStacks] = scala
      .Option(impl.includeNestedStacks())
      .map(value =>
        zio.aws.cloudformation.model.primitives.IncludeNestedStacks(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest
  ): zio.aws.cloudformation.model.CreateChangeSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
