package zio.aws.cloudformation
import zio.aws.cloudformation.model.DescribeTypeResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.cloudformation.model.{
  CreateChangeSetRequest,
  SetTypeDefaultVersionRequest,
  ListStackInstancesRequest,
  GetStackPolicyRequest,
  ValidateTemplateRequest,
  DescribeStacksRequest,
  CreateStackInstancesRequest,
  CreateStackSetRequest,
  ActivateTypeRequest,
  DeactivateTypeRequest,
  ListImportsRequest,
  UpdateTerminationProtectionRequest,
  UpdateStackInstancesRequest,
  DescribeStackResourcesRequest,
  RegisterPublisherRequest,
  ListStackSetOperationResultsRequest,
  ListTypeRegistrationsRequest,
  DescribePublisherRequest,
  DescribeTypeRegistrationRequest,
  DescribeStackResourceDriftsRequest,
  SetTypeConfigurationRequest,
  ListStackResourcesRequest,
  RecordHandlerProgressRequest,
  ListExportsRequest,
  DetectStackSetDriftRequest,
  DeleteStackInstancesRequest,
  PublishTypeRequest,
  DeleteStackRequest,
  DeleteStackSetRequest,
  ListTypesRequest,
  DescribeStackEventsRequest,
  ExecuteChangeSetRequest,
  StopStackSetOperationRequest,
  DescribeStackSetOperationRequest,
  DescribeStackSetRequest,
  RollbackStackRequest,
  TestTypeRequest,
  ContinueUpdateRollbackRequest,
  ListTypeVersionsRequest,
  DetectStackResourceDriftRequest,
  CancelUpdateStackRequest,
  GetTemplateSummaryRequest,
  DeleteChangeSetRequest,
  DescribeStackDriftDetectionStatusRequest,
  UpdateStackSetRequest,
  ListStackSetsRequest,
  DescribeStackResourceRequest,
  DescribeAccountLimitsRequest,
  DetectStackDriftRequest,
  DescribeStackInstanceRequest,
  SetStackPolicyRequest,
  DescribeTypeRequest,
  ListChangeSetsRequest,
  GetTemplateRequest,
  SignalResourceRequest,
  ListStackSetOperationsRequest,
  EstimateTemplateCostRequest,
  ListStacksRequest,
  ImportStacksToStackSetRequest,
  DeregisterTypeRequest,
  UpdateStackRequest,
  BatchDescribeTypeConfigurationsRequest,
  CreateStackRequest,
  DescribeChangeSetRequest,
  RegisterTypeRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient
import zio.stream.ZStream
import zio.aws.cloudformation.model.primitives.{RegistrationToken, StackName}
object CloudFormationMock extends Mock[CloudFormation] {
  object ListTypes
      extends Stream[
        ListTypesRequest,
        AwsError,
        zio.aws.cloudformation.model.TypeSummary.ReadOnly
      ]
  object ListTypesPaginated
      extends Effect[
        ListTypesRequest,
        AwsError,
        zio.aws.cloudformation.model.ListTypesResponse.ReadOnly
      ]
  object DeleteStackSet
      extends Effect[
        DeleteStackSetRequest,
        AwsError,
        zio.aws.cloudformation.model.DeleteStackSetResponse.ReadOnly
      ]
  object DescribeStacks
      extends Stream[
        DescribeStacksRequest,
        AwsError,
        zio.aws.cloudformation.model.Stack.ReadOnly
      ]
  object DescribeStacksPaginated
      extends Effect[
        DescribeStacksRequest,
        AwsError,
        zio.aws.cloudformation.model.DescribeStacksResponse.ReadOnly
      ]
  object ExecuteChangeSet
      extends Effect[
        ExecuteChangeSetRequest,
        AwsError,
        zio.aws.cloudformation.model.ExecuteChangeSetResponse.ReadOnly
      ]
  object RegisterType
      extends Effect[
        RegisterTypeRequest,
        AwsError,
        zio.aws.cloudformation.model.RegisterTypeResponse.ReadOnly
      ]
  object DescribeStackSetOperation
      extends Effect[
        DescribeStackSetOperationRequest,
        AwsError,
        zio.aws.cloudformation.model.DescribeStackSetOperationResponse.ReadOnly
      ]
  object ImportStacksToStackSet
      extends Effect[
        ImportStacksToStackSetRequest,
        AwsError,
        zio.aws.cloudformation.model.ImportStacksToStackSetResponse.ReadOnly
      ]
  object SignalResource extends Effect[SignalResourceRequest, AwsError, Unit]
  object DescribeStackResource
      extends Effect[
        DescribeStackResourceRequest,
        AwsError,
        zio.aws.cloudformation.model.DescribeStackResourceResponse.ReadOnly
      ]
  object DescribeStackSet
      extends Effect[
        DescribeStackSetRequest,
        AwsError,
        zio.aws.cloudformation.model.DescribeStackSetResponse.ReadOnly
      ]
  object SetStackPolicy extends Effect[SetStackPolicyRequest, AwsError, Unit]
  object ListImports extends Stream[ListImportsRequest, AwsError, StackName]
  object ListImportsPaginated
      extends Effect[
        ListImportsRequest,
        AwsError,
        zio.aws.cloudformation.model.ListImportsResponse.ReadOnly
      ]
  object DescribeStackEvents
      extends Stream[
        DescribeStackEventsRequest,
        AwsError,
        zio.aws.cloudformation.model.StackEvent.ReadOnly
      ]
  object DescribeStackEventsPaginated
      extends Effect[
        DescribeStackEventsRequest,
        AwsError,
        zio.aws.cloudformation.model.DescribeStackEventsResponse.ReadOnly
      ]
  object UpdateTerminationProtection
      extends Effect[
        UpdateTerminationProtectionRequest,
        AwsError,
        zio.aws.cloudformation.model.UpdateTerminationProtectionResponse.ReadOnly
      ]
  object DescribeStackInstance
      extends Effect[
        DescribeStackInstanceRequest,
        AwsError,
        zio.aws.cloudformation.model.DescribeStackInstanceResponse.ReadOnly
      ]
  object CreateStackSet
      extends Effect[
        CreateStackSetRequest,
        AwsError,
        zio.aws.cloudformation.model.CreateStackSetResponse.ReadOnly
      ]
  object DescribeAccountLimits
      extends Stream[
        DescribeAccountLimitsRequest,
        AwsError,
        zio.aws.cloudformation.model.AccountLimit.ReadOnly
      ]
  object DescribeAccountLimitsPaginated
      extends Effect[
        DescribeAccountLimitsRequest,
        AwsError,
        zio.aws.cloudformation.model.DescribeAccountLimitsResponse.ReadOnly
      ]
  object UpdateStackSet
      extends Effect[
        UpdateStackSetRequest,
        AwsError,
        zio.aws.cloudformation.model.UpdateStackSetResponse.ReadOnly
      ]
  object SetTypeDefaultVersion
      extends Effect[
        SetTypeDefaultVersionRequest,
        AwsError,
        zio.aws.cloudformation.model.SetTypeDefaultVersionResponse.ReadOnly
      ]
  object GetTemplateSummary
      extends Effect[
        GetTemplateSummaryRequest,
        AwsError,
        zio.aws.cloudformation.model.GetTemplateSummaryResponse.ReadOnly
      ]
  object ListExports
      extends Stream[
        ListExportsRequest,
        AwsError,
        zio.aws.cloudformation.model.Export.ReadOnly
      ]
  object ListExportsPaginated
      extends Effect[
        ListExportsRequest,
        AwsError,
        zio.aws.cloudformation.model.ListExportsResponse.ReadOnly
      ]
  object RegisterPublisher
      extends Effect[
        RegisterPublisherRequest,
        AwsError,
        zio.aws.cloudformation.model.RegisterPublisherResponse.ReadOnly
      ]
  object ActivateType
      extends Effect[
        ActivateTypeRequest,
        AwsError,
        zio.aws.cloudformation.model.ActivateTypeResponse.ReadOnly
      ]
  object PublishType
      extends Effect[
        PublishTypeRequest,
        AwsError,
        zio.aws.cloudformation.model.PublishTypeResponse.ReadOnly
      ]
  object DescribeStackResourceDrifts
      extends Stream[
        DescribeStackResourceDriftsRequest,
        AwsError,
        zio.aws.cloudformation.model.StackResourceDrift.ReadOnly
      ]
  object DescribeStackResourceDriftsPaginated
      extends Effect[
        DescribeStackResourceDriftsRequest,
        AwsError,
        zio.aws.cloudformation.model.DescribeStackResourceDriftsResponse.ReadOnly
      ]
  object RecordHandlerProgress
      extends Effect[
        RecordHandlerProgressRequest,
        AwsError,
        zio.aws.cloudformation.model.RecordHandlerProgressResponse.ReadOnly
      ]
  object ListChangeSets
      extends Stream[
        ListChangeSetsRequest,
        AwsError,
        zio.aws.cloudformation.model.ChangeSetSummary.ReadOnly
      ]
  object ListChangeSetsPaginated
      extends Effect[
        ListChangeSetsRequest,
        AwsError,
        zio.aws.cloudformation.model.ListChangeSetsResponse.ReadOnly
      ]
  object DeactivateType
      extends Effect[
        DeactivateTypeRequest,
        AwsError,
        zio.aws.cloudformation.model.DeactivateTypeResponse.ReadOnly
      ]
  object BatchDescribeTypeConfigurations
      extends Effect[
        BatchDescribeTypeConfigurationsRequest,
        AwsError,
        zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsResponse.ReadOnly
      ]
  object CreateChangeSet
      extends Effect[
        CreateChangeSetRequest,
        AwsError,
        zio.aws.cloudformation.model.CreateChangeSetResponse.ReadOnly
      ]
  object ContinueUpdateRollback
      extends Effect[
        ContinueUpdateRollbackRequest,
        AwsError,
        zio.aws.cloudformation.model.ContinueUpdateRollbackResponse.ReadOnly
      ]
  object RollbackStack
      extends Effect[
        RollbackStackRequest,
        AwsError,
        zio.aws.cloudformation.model.RollbackStackResponse.ReadOnly
      ]
  object CancelUpdateStack
      extends Effect[CancelUpdateStackRequest, AwsError, Unit]
  object DescribeChangeSet
      extends Effect[DescribeChangeSetRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.cloudformation.model.DescribeChangeSetResponse.ReadOnly,
        zio.aws.cloudformation.model.Change.ReadOnly
      ]]
  object DescribeChangeSetPaginated
      extends Effect[
        DescribeChangeSetRequest,
        AwsError,
        zio.aws.cloudformation.model.DescribeChangeSetResponse.ReadOnly
      ]
  object DetectStackDrift
      extends Effect[
        DetectStackDriftRequest,
        AwsError,
        zio.aws.cloudformation.model.DetectStackDriftResponse.ReadOnly
      ]
  object ListStacks
      extends Stream[
        ListStacksRequest,
        AwsError,
        zio.aws.cloudformation.model.StackSummary.ReadOnly
      ]
  object ListStacksPaginated
      extends Effect[
        ListStacksRequest,
        AwsError,
        zio.aws.cloudformation.model.ListStacksResponse.ReadOnly
      ]
  object DeleteChangeSet
      extends Effect[
        DeleteChangeSetRequest,
        AwsError,
        zio.aws.cloudformation.model.DeleteChangeSetResponse.ReadOnly
      ]
  object DescribeTypeRegistration
      extends Effect[
        DescribeTypeRegistrationRequest,
        AwsError,
        zio.aws.cloudformation.model.DescribeTypeRegistrationResponse.ReadOnly
      ]
  object ListStackInstances
      extends Stream[
        ListStackInstancesRequest,
        AwsError,
        zio.aws.cloudformation.model.StackInstanceSummary.ReadOnly
      ]
  object ListStackInstancesPaginated
      extends Effect[
        ListStackInstancesRequest,
        AwsError,
        zio.aws.cloudformation.model.ListStackInstancesResponse.ReadOnly
      ]
  object DetectStackResourceDrift
      extends Effect[
        DetectStackResourceDriftRequest,
        AwsError,
        zio.aws.cloudformation.model.DetectStackResourceDriftResponse.ReadOnly
      ]
  object DescribePublisher
      extends Effect[
        DescribePublisherRequest,
        AwsError,
        zio.aws.cloudformation.model.DescribePublisherResponse.ReadOnly
      ]
  object ListStackSetOperationResults
      extends Stream[
        ListStackSetOperationResultsRequest,
        AwsError,
        zio.aws.cloudformation.model.StackSetOperationResultSummary.ReadOnly
      ]
  object ListStackSetOperationResultsPaginated
      extends Effect[
        ListStackSetOperationResultsRequest,
        AwsError,
        zio.aws.cloudformation.model.ListStackSetOperationResultsResponse.ReadOnly
      ]
  object DescribeStackResources
      extends Effect[
        DescribeStackResourcesRequest,
        AwsError,
        zio.aws.cloudformation.model.DescribeStackResourcesResponse.ReadOnly
      ]
  object ListStackSets
      extends Stream[
        ListStackSetsRequest,
        AwsError,
        zio.aws.cloudformation.model.StackSetSummary.ReadOnly
      ]
  object ListStackSetsPaginated
      extends Effect[
        ListStackSetsRequest,
        AwsError,
        zio.aws.cloudformation.model.ListStackSetsResponse.ReadOnly
      ]
  object DescribeType extends Effect[DescribeTypeRequest, AwsError, ReadOnly]
  object EstimateTemplateCost
      extends Effect[
        EstimateTemplateCostRequest,
        AwsError,
        zio.aws.cloudformation.model.EstimateTemplateCostResponse.ReadOnly
      ]
  object TestType
      extends Effect[
        TestTypeRequest,
        AwsError,
        zio.aws.cloudformation.model.TestTypeResponse.ReadOnly
      ]
  object ValidateTemplate
      extends Effect[
        ValidateTemplateRequest,
        AwsError,
        zio.aws.cloudformation.model.ValidateTemplateResponse.ReadOnly
      ]
  object ListTypeVersions
      extends Stream[
        ListTypeVersionsRequest,
        AwsError,
        zio.aws.cloudformation.model.TypeVersionSummary.ReadOnly
      ]
  object ListTypeVersionsPaginated
      extends Effect[
        ListTypeVersionsRequest,
        AwsError,
        zio.aws.cloudformation.model.ListTypeVersionsResponse.ReadOnly
      ]
  object UpdateStack
      extends Effect[
        UpdateStackRequest,
        AwsError,
        zio.aws.cloudformation.model.UpdateStackResponse.ReadOnly
      ]
  object DeregisterType
      extends Effect[
        DeregisterTypeRequest,
        AwsError,
        zio.aws.cloudformation.model.DeregisterTypeResponse.ReadOnly
      ]
  object DeleteStack extends Effect[DeleteStackRequest, AwsError, Unit]
  object StopStackSetOperation
      extends Effect[
        StopStackSetOperationRequest,
        AwsError,
        zio.aws.cloudformation.model.StopStackSetOperationResponse.ReadOnly
      ]
  object ListTypeRegistrations
      extends Stream[ListTypeRegistrationsRequest, AwsError, RegistrationToken]
  object ListTypeRegistrationsPaginated
      extends Effect[
        ListTypeRegistrationsRequest,
        AwsError,
        zio.aws.cloudformation.model.ListTypeRegistrationsResponse.ReadOnly
      ]
  object SetTypeConfiguration
      extends Effect[
        SetTypeConfigurationRequest,
        AwsError,
        zio.aws.cloudformation.model.SetTypeConfigurationResponse.ReadOnly
      ]
  object UpdateStackInstances
      extends Effect[
        UpdateStackInstancesRequest,
        AwsError,
        zio.aws.cloudformation.model.UpdateStackInstancesResponse.ReadOnly
      ]
  object CreateStack
      extends Effect[
        CreateStackRequest,
        AwsError,
        zio.aws.cloudformation.model.CreateStackResponse.ReadOnly
      ]
  object DescribeStackDriftDetectionStatus
      extends Effect[
        DescribeStackDriftDetectionStatusRequest,
        AwsError,
        zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusResponse.ReadOnly
      ]
  object DeleteStackInstances
      extends Effect[
        DeleteStackInstancesRequest,
        AwsError,
        zio.aws.cloudformation.model.DeleteStackInstancesResponse.ReadOnly
      ]
  object GetTemplate
      extends Effect[
        GetTemplateRequest,
        AwsError,
        zio.aws.cloudformation.model.GetTemplateResponse.ReadOnly
      ]
  object GetStackPolicy
      extends Effect[
        GetStackPolicyRequest,
        AwsError,
        zio.aws.cloudformation.model.GetStackPolicyResponse.ReadOnly
      ]
  object ListStackSetOperations
      extends Stream[
        ListStackSetOperationsRequest,
        AwsError,
        zio.aws.cloudformation.model.StackSetOperationSummary.ReadOnly
      ]
  object ListStackSetOperationsPaginated
      extends Effect[
        ListStackSetOperationsRequest,
        AwsError,
        zio.aws.cloudformation.model.ListStackSetOperationsResponse.ReadOnly
      ]
  object CreateStackInstances
      extends Effect[
        CreateStackInstancesRequest,
        AwsError,
        zio.aws.cloudformation.model.CreateStackInstancesResponse.ReadOnly
      ]
  object ListStackResources
      extends Stream[
        ListStackResourcesRequest,
        AwsError,
        zio.aws.cloudformation.model.StackResourceSummary.ReadOnly
      ]
  object ListStackResourcesPaginated
      extends Effect[
        ListStackResourcesRequest,
        AwsError,
        zio.aws.cloudformation.model.ListStackResourcesResponse.ReadOnly
      ]
  object DetectStackSetDrift
      extends Effect[
        DetectStackSetDriftRequest,
        AwsError,
        zio.aws.cloudformation.model.DetectStackSetDriftResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CloudFormation] = ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new CloudFormation {
          val api: CloudFormationAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : CloudFormation = this
          def listTypes(request: ListTypesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.cloudformation.model.TypeSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListTypes, request))
          def listTypesPaginated(request: ListTypesRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.ListTypesResponse.ReadOnly
          ] = proxy(ListTypesPaginated, request)
          def deleteStackSet(request: DeleteStackSetRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.DeleteStackSetResponse.ReadOnly
          ] = proxy(DeleteStackSet, request)
          def describeStacks(request: DescribeStacksRequest): ZStream[
            Any,
            AwsError,
            zio.aws.cloudformation.model.Stack.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeStacks, request))
          def describeStacksPaginated(request: DescribeStacksRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.DescribeStacksResponse.ReadOnly
          ] = proxy(DescribeStacksPaginated, request)
          def executeChangeSet(request: ExecuteChangeSetRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.ExecuteChangeSetResponse.ReadOnly
          ] = proxy(ExecuteChangeSet, request)
          def registerType(request: RegisterTypeRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.RegisterTypeResponse.ReadOnly
          ] = proxy(RegisterType, request)
          def describeStackSetOperation(
              request: DescribeStackSetOperationRequest
          ): IO[
            AwsError,
            zio.aws.cloudformation.model.DescribeStackSetOperationResponse.ReadOnly
          ] = proxy(DescribeStackSetOperation, request)
          def importStacksToStackSet(
              request: ImportStacksToStackSetRequest
          ): IO[
            AwsError,
            zio.aws.cloudformation.model.ImportStacksToStackSetResponse.ReadOnly
          ] = proxy(ImportStacksToStackSet, request)
          def signalResource(
              request: SignalResourceRequest
          ): IO[AwsError, Unit] = proxy(SignalResource, request)
          def describeStackResource(request: DescribeStackResourceRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.DescribeStackResourceResponse.ReadOnly
          ] = proxy(DescribeStackResource, request)
          def describeStackSet(request: DescribeStackSetRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.DescribeStackSetResponse.ReadOnly
          ] = proxy(DescribeStackSet, request)
          def setStackPolicy(
              request: SetStackPolicyRequest
          ): IO[AwsError, Unit] = proxy(SetStackPolicy, request)
          def listImports(
              request: ListImportsRequest
          ): ZStream[Any, AwsError, StackName] =
            rts.unsafeRun(proxy(ListImports, request))
          def listImportsPaginated(request: ListImportsRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.ListImportsResponse.ReadOnly
          ] = proxy(ListImportsPaginated, request)
          def describeStackEvents(request: DescribeStackEventsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.cloudformation.model.StackEvent.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeStackEvents, request))
          def describeStackEventsPaginated(
              request: DescribeStackEventsRequest
          ): IO[
            AwsError,
            zio.aws.cloudformation.model.DescribeStackEventsResponse.ReadOnly
          ] = proxy(DescribeStackEventsPaginated, request)
          def updateTerminationProtection(
              request: UpdateTerminationProtectionRequest
          ): IO[
            AwsError,
            zio.aws.cloudformation.model.UpdateTerminationProtectionResponse.ReadOnly
          ] = proxy(UpdateTerminationProtection, request)
          def describeStackInstance(request: DescribeStackInstanceRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.DescribeStackInstanceResponse.ReadOnly
          ] = proxy(DescribeStackInstance, request)
          def createStackSet(request: CreateStackSetRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.CreateStackSetResponse.ReadOnly
          ] = proxy(CreateStackSet, request)
          def describeAccountLimits(
              request: DescribeAccountLimitsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.cloudformation.model.AccountLimit.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeAccountLimits, request))
          def describeAccountLimitsPaginated(
              request: DescribeAccountLimitsRequest
          ): IO[
            AwsError,
            zio.aws.cloudformation.model.DescribeAccountLimitsResponse.ReadOnly
          ] = proxy(DescribeAccountLimitsPaginated, request)
          def updateStackSet(request: UpdateStackSetRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.UpdateStackSetResponse.ReadOnly
          ] = proxy(UpdateStackSet, request)
          def setTypeDefaultVersion(request: SetTypeDefaultVersionRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.SetTypeDefaultVersionResponse.ReadOnly
          ] = proxy(SetTypeDefaultVersion, request)
          def getTemplateSummary(request: GetTemplateSummaryRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.GetTemplateSummaryResponse.ReadOnly
          ] = proxy(GetTemplateSummary, request)
          def listExports(request: ListExportsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.cloudformation.model.Export.ReadOnly
          ] = rts.unsafeRun(proxy(ListExports, request))
          def listExportsPaginated(request: ListExportsRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.ListExportsResponse.ReadOnly
          ] = proxy(ListExportsPaginated, request)
          def registerPublisher(request: RegisterPublisherRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.RegisterPublisherResponse.ReadOnly
          ] = proxy(RegisterPublisher, request)
          def activateType(request: ActivateTypeRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.ActivateTypeResponse.ReadOnly
          ] = proxy(ActivateType, request)
          def publishType(request: PublishTypeRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.PublishTypeResponse.ReadOnly
          ] = proxy(PublishType, request)
          def describeStackResourceDrifts(
              request: DescribeStackResourceDriftsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.cloudformation.model.StackResourceDrift.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeStackResourceDrifts, request))
          def describeStackResourceDriftsPaginated(
              request: DescribeStackResourceDriftsRequest
          ): IO[
            AwsError,
            zio.aws.cloudformation.model.DescribeStackResourceDriftsResponse.ReadOnly
          ] = proxy(DescribeStackResourceDriftsPaginated, request)
          def recordHandlerProgress(request: RecordHandlerProgressRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.RecordHandlerProgressResponse.ReadOnly
          ] = proxy(RecordHandlerProgress, request)
          def listChangeSets(request: ListChangeSetsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.cloudformation.model.ChangeSetSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListChangeSets, request))
          def listChangeSetsPaginated(request: ListChangeSetsRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.ListChangeSetsResponse.ReadOnly
          ] = proxy(ListChangeSetsPaginated, request)
          def deactivateType(request: DeactivateTypeRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.DeactivateTypeResponse.ReadOnly
          ] = proxy(DeactivateType, request)
          def batchDescribeTypeConfigurations(
              request: BatchDescribeTypeConfigurationsRequest
          ): IO[
            AwsError,
            zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsResponse.ReadOnly
          ] = proxy(BatchDescribeTypeConfigurations, request)
          def createChangeSet(request: CreateChangeSetRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.CreateChangeSetResponse.ReadOnly
          ] = proxy(CreateChangeSet, request)
          def continueUpdateRollback(
              request: ContinueUpdateRollbackRequest
          ): IO[
            AwsError,
            zio.aws.cloudformation.model.ContinueUpdateRollbackResponse.ReadOnly
          ] = proxy(ContinueUpdateRollback, request)
          def rollbackStack(request: RollbackStackRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.RollbackStackResponse.ReadOnly
          ] = proxy(RollbackStack, request)
          def cancelUpdateStack(
              request: CancelUpdateStackRequest
          ): IO[AwsError, Unit] = proxy(CancelUpdateStack, request)
          def describeChangeSet(
              request: DescribeChangeSetRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.cloudformation.model.DescribeChangeSetResponse.ReadOnly,
            zio.aws.cloudformation.model.Change.ReadOnly
          ]] = proxy(DescribeChangeSet, request)
          def describeChangeSetPaginated(request: DescribeChangeSetRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.DescribeChangeSetResponse.ReadOnly
          ] = proxy(DescribeChangeSetPaginated, request)
          def detectStackDrift(request: DetectStackDriftRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.DetectStackDriftResponse.ReadOnly
          ] = proxy(DetectStackDrift, request)
          def listStacks(request: ListStacksRequest): ZStream[
            Any,
            AwsError,
            zio.aws.cloudformation.model.StackSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListStacks, request))
          def listStacksPaginated(request: ListStacksRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.ListStacksResponse.ReadOnly
          ] = proxy(ListStacksPaginated, request)
          def deleteChangeSet(request: DeleteChangeSetRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.DeleteChangeSetResponse.ReadOnly
          ] = proxy(DeleteChangeSet, request)
          def describeTypeRegistration(
              request: DescribeTypeRegistrationRequest
          ): IO[
            AwsError,
            zio.aws.cloudformation.model.DescribeTypeRegistrationResponse.ReadOnly
          ] = proxy(DescribeTypeRegistration, request)
          def listStackInstances(request: ListStackInstancesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.cloudformation.model.StackInstanceSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListStackInstances, request))
          def listStackInstancesPaginated(
              request: ListStackInstancesRequest
          ): IO[
            AwsError,
            zio.aws.cloudformation.model.ListStackInstancesResponse.ReadOnly
          ] = proxy(ListStackInstancesPaginated, request)
          def detectStackResourceDrift(
              request: DetectStackResourceDriftRequest
          ): IO[
            AwsError,
            zio.aws.cloudformation.model.DetectStackResourceDriftResponse.ReadOnly
          ] = proxy(DetectStackResourceDrift, request)
          def describePublisher(request: DescribePublisherRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.DescribePublisherResponse.ReadOnly
          ] = proxy(DescribePublisher, request)
          def listStackSetOperationResults(
              request: ListStackSetOperationResultsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.cloudformation.model.StackSetOperationResultSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListStackSetOperationResults, request))
          def listStackSetOperationResultsPaginated(
              request: ListStackSetOperationResultsRequest
          ): IO[
            AwsError,
            zio.aws.cloudformation.model.ListStackSetOperationResultsResponse.ReadOnly
          ] = proxy(ListStackSetOperationResultsPaginated, request)
          def describeStackResources(
              request: DescribeStackResourcesRequest
          ): IO[
            AwsError,
            zio.aws.cloudformation.model.DescribeStackResourcesResponse.ReadOnly
          ] = proxy(DescribeStackResources, request)
          def listStackSets(request: ListStackSetsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.cloudformation.model.StackSetSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListStackSets, request))
          def listStackSetsPaginated(request: ListStackSetsRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.ListStackSetsResponse.ReadOnly
          ] = proxy(ListStackSetsPaginated, request)
          def describeType(
              request: DescribeTypeRequest
          ): IO[AwsError, ReadOnly] = proxy(DescribeType, request)
          def estimateTemplateCost(request: EstimateTemplateCostRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.EstimateTemplateCostResponse.ReadOnly
          ] = proxy(EstimateTemplateCost, request)
          def testType(request: TestTypeRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.TestTypeResponse.ReadOnly
          ] = proxy(TestType, request)
          def validateTemplate(request: ValidateTemplateRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.ValidateTemplateResponse.ReadOnly
          ] = proxy(ValidateTemplate, request)
          def listTypeVersions(request: ListTypeVersionsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.cloudformation.model.TypeVersionSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListTypeVersions, request))
          def listTypeVersionsPaginated(request: ListTypeVersionsRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.ListTypeVersionsResponse.ReadOnly
          ] = proxy(ListTypeVersionsPaginated, request)
          def updateStack(request: UpdateStackRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.UpdateStackResponse.ReadOnly
          ] = proxy(UpdateStack, request)
          def deregisterType(request: DeregisterTypeRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.DeregisterTypeResponse.ReadOnly
          ] = proxy(DeregisterType, request)
          def deleteStack(request: DeleteStackRequest): IO[AwsError, Unit] =
            proxy(DeleteStack, request)
          def stopStackSetOperation(request: StopStackSetOperationRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.StopStackSetOperationResponse.ReadOnly
          ] = proxy(StopStackSetOperation, request)
          def listTypeRegistrations(
              request: ListTypeRegistrationsRequest
          ): ZStream[Any, AwsError, RegistrationToken] =
            rts.unsafeRun(proxy(ListTypeRegistrations, request))
          def listTypeRegistrationsPaginated(
              request: ListTypeRegistrationsRequest
          ): IO[
            AwsError,
            zio.aws.cloudformation.model.ListTypeRegistrationsResponse.ReadOnly
          ] = proxy(ListTypeRegistrationsPaginated, request)
          def setTypeConfiguration(request: SetTypeConfigurationRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.SetTypeConfigurationResponse.ReadOnly
          ] = proxy(SetTypeConfiguration, request)
          def updateStackInstances(request: UpdateStackInstancesRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.UpdateStackInstancesResponse.ReadOnly
          ] = proxy(UpdateStackInstances, request)
          def createStack(request: CreateStackRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.CreateStackResponse.ReadOnly
          ] = proxy(CreateStack, request)
          def describeStackDriftDetectionStatus(
              request: DescribeStackDriftDetectionStatusRequest
          ): IO[
            AwsError,
            zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusResponse.ReadOnly
          ] = proxy(DescribeStackDriftDetectionStatus, request)
          def deleteStackInstances(request: DeleteStackInstancesRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.DeleteStackInstancesResponse.ReadOnly
          ] = proxy(DeleteStackInstances, request)
          def getTemplate(request: GetTemplateRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.GetTemplateResponse.ReadOnly
          ] = proxy(GetTemplate, request)
          def getStackPolicy(request: GetStackPolicyRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.GetStackPolicyResponse.ReadOnly
          ] = proxy(GetStackPolicy, request)
          def listStackSetOperations(
              request: ListStackSetOperationsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.cloudformation.model.StackSetOperationSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListStackSetOperations, request))
          def listStackSetOperationsPaginated(
              request: ListStackSetOperationsRequest
          ): IO[
            AwsError,
            zio.aws.cloudformation.model.ListStackSetOperationsResponse.ReadOnly
          ] = proxy(ListStackSetOperationsPaginated, request)
          def createStackInstances(request: CreateStackInstancesRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.CreateStackInstancesResponse.ReadOnly
          ] = proxy(CreateStackInstances, request)
          def listStackResources(request: ListStackResourcesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.cloudformation.model.StackResourceSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListStackResources, request))
          def listStackResourcesPaginated(
              request: ListStackResourcesRequest
          ): IO[
            AwsError,
            zio.aws.cloudformation.model.ListStackResourcesResponse.ReadOnly
          ] = proxy(ListStackResourcesPaginated, request)
          def detectStackSetDrift(request: DetectStackSetDriftRequest): IO[
            AwsError,
            zio.aws.cloudformation.model.DetectStackSetDriftResponse.ReadOnly
          ] = proxy(DetectStackSetDrift, request)
        }
      }
    }
    .toLayer
}
