package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait Visibility {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.Visibility
}
object Visibility {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.Visibility
  ): zio.aws.cloudformation.model.Visibility = value match {
    case software.amazon.awssdk.services.cloudformation.model.Visibility.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.Visibility.PUBLIC =>
      val r = PUBLIC
      r
    case software.amazon.awssdk.services.cloudformation.model.Visibility.PRIVATE =>
      val r = PRIVATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.Visibility {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.Visibility =
      software.amazon.awssdk.services.cloudformation.model.Visibility.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLIC extends zio.aws.cloudformation.model.Visibility {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.Visibility =
      software.amazon.awssdk.services.cloudformation.model.Visibility.PUBLIC
  }
  case object PRIVATE extends zio.aws.cloudformation.model.Visibility {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.Visibility =
      software.amazon.awssdk.services.cloudformation.model.Visibility.PRIVATE
  }
}
