package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{TypeNamePrefix, PublisherId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TypeFilters(
    category: Option[zio.aws.cloudformation.model.Category] = None,
    publisherId: Option[PublisherId] = None,
    typeNamePrefix: Option[TypeNamePrefix] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.TypeFilters = {
    import TypeFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.TypeFilters
      .builder()
      .optionallyWith(category.map(value => value.unwrap))(_.category)
      .optionallyWith(
        publisherId.map(value => PublisherId.unwrap(value): java.lang.String)
      )(_.publisherId)
      .optionallyWith(
        typeNamePrefix.map(value =>
          TypeNamePrefix.unwrap(value): java.lang.String
        )
      )(_.typeNamePrefix)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.TypeFilters.ReadOnly =
    zio.aws.cloudformation.model.TypeFilters.wrap(buildAwsValue())
}
object TypeFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.TypeFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.TypeFilters =
      zio.aws.cloudformation.model.TypeFilters(
        category.map(value => value),
        publisherId.map(value => value),
        typeNamePrefix.map(value => value)
      )
    def category: Option[zio.aws.cloudformation.model.Category]
    def publisherId: Option[PublisherId]
    def typeNamePrefix: Option[TypeNamePrefix]
    def getCategory: ZIO[Any, AwsError, zio.aws.cloudformation.model.Category] =
      AwsError.unwrapOptionField("category", category)
    def getPublisherId: ZIO[Any, AwsError, PublisherId] =
      AwsError.unwrapOptionField("publisherId", publisherId)
    def getTypeNamePrefix: ZIO[Any, AwsError, TypeNamePrefix] =
      AwsError.unwrapOptionField("typeNamePrefix", typeNamePrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.TypeFilters
  ) extends zio.aws.cloudformation.model.TypeFilters.ReadOnly {
    override val category: Option[zio.aws.cloudformation.model.Category] = scala
      .Option(impl.category())
      .map(value => zio.aws.cloudformation.model.Category.wrap(value))
    override val publisherId: Option[PublisherId] = scala
      .Option(impl.publisherId())
      .map(value => zio.aws.cloudformation.model.primitives.PublisherId(value))
    override val typeNamePrefix: Option[TypeNamePrefix] = scala
      .Option(impl.typeNamePrefix())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TypeNamePrefix(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.TypeFilters
  ): zio.aws.cloudformation.model.TypeFilters.ReadOnly = new Wrapper(impl)
}
