package zio.aws.cloudformation.model
import java.lang.Integer
import zio.aws.cloudformation.model.primitives.{
  FailureToleranceCount,
  MaxConcurrentPercentage,
  FailureTolerancePercentage,
  MaxConcurrentCount,
  Region
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StackSetOperationPreferences(
    regionConcurrencyType: Option[
      zio.aws.cloudformation.model.RegionConcurrencyType
    ] = None,
    regionOrder: Option[Iterable[Region]] = None,
    failureToleranceCount: Option[FailureToleranceCount] = None,
    failureTolerancePercentage: Option[FailureTolerancePercentage] = None,
    maxConcurrentCount: Option[MaxConcurrentCount] = None,
    maxConcurrentPercentage: Option[MaxConcurrentPercentage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackSetOperationPreferences = {
    import StackSetOperationPreferences.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackSetOperationPreferences
      .builder()
      .optionallyWith(regionConcurrencyType.map(value => value.unwrap))(
        _.regionConcurrencyType
      )
      .optionallyWith(
        regionOrder.map(value =>
          value.map { item =>
            Region.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.regionOrder)
      .optionallyWith(
        failureToleranceCount.map(value =>
          FailureToleranceCount.unwrap(value): Integer
        )
      )(_.failureToleranceCount)
      .optionallyWith(
        failureTolerancePercentage.map(value =>
          FailureTolerancePercentage.unwrap(value): Integer
        )
      )(_.failureTolerancePercentage)
      .optionallyWith(
        maxConcurrentCount.map(value =>
          MaxConcurrentCount.unwrap(value): Integer
        )
      )(_.maxConcurrentCount)
      .optionallyWith(
        maxConcurrentPercentage.map(value =>
          MaxConcurrentPercentage.unwrap(value): Integer
        )
      )(_.maxConcurrentPercentage)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly =
    zio.aws.cloudformation.model.StackSetOperationPreferences
      .wrap(buildAwsValue())
}
object StackSetOperationPreferences {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackSetOperationPreferences
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackSetOperationPreferences =
      zio.aws.cloudformation.model.StackSetOperationPreferences(
        regionConcurrencyType.map(value => value),
        regionOrder.map(value => value),
        failureToleranceCount.map(value => value),
        failureTolerancePercentage.map(value => value),
        maxConcurrentCount.map(value => value),
        maxConcurrentPercentage.map(value => value)
      )
    def regionConcurrencyType
        : Option[zio.aws.cloudformation.model.RegionConcurrencyType]
    def regionOrder: Option[List[Region]]
    def failureToleranceCount: Option[FailureToleranceCount]
    def failureTolerancePercentage: Option[FailureTolerancePercentage]
    def maxConcurrentCount: Option[MaxConcurrentCount]
    def maxConcurrentPercentage: Option[MaxConcurrentPercentage]
    def getRegionConcurrencyType: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.RegionConcurrencyType
    ] =
      AwsError.unwrapOptionField("regionConcurrencyType", regionConcurrencyType)
    def getRegionOrder: ZIO[Any, AwsError, List[Region]] =
      AwsError.unwrapOptionField("regionOrder", regionOrder)
    def getFailureToleranceCount: ZIO[Any, AwsError, FailureToleranceCount] =
      AwsError.unwrapOptionField("failureToleranceCount", failureToleranceCount)
    def getFailureTolerancePercentage
        : ZIO[Any, AwsError, FailureTolerancePercentage] =
      AwsError.unwrapOptionField(
        "failureTolerancePercentage",
        failureTolerancePercentage
      )
    def getMaxConcurrentCount: ZIO[Any, AwsError, MaxConcurrentCount] =
      AwsError.unwrapOptionField("maxConcurrentCount", maxConcurrentCount)
    def getMaxConcurrentPercentage
        : ZIO[Any, AwsError, MaxConcurrentPercentage] = AwsError
      .unwrapOptionField("maxConcurrentPercentage", maxConcurrentPercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetOperationPreferences
  ) extends zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly {
    override val regionConcurrencyType
        : Option[zio.aws.cloudformation.model.RegionConcurrencyType] = scala
      .Option(impl.regionConcurrencyType())
      .map(value =>
        zio.aws.cloudformation.model.RegionConcurrencyType.wrap(value)
      )
    override val regionOrder: Option[List[Region]] = scala
      .Option(impl.regionOrder())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.Region(item)
        }.toList
      )
    override val failureToleranceCount: Option[FailureToleranceCount] = scala
      .Option(impl.failureToleranceCount())
      .map(value =>
        zio.aws.cloudformation.model.primitives.FailureToleranceCount(value)
      )
    override val failureTolerancePercentage
        : Option[FailureTolerancePercentage] = scala
      .Option(impl.failureTolerancePercentage())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .FailureTolerancePercentage(value)
      )
    override val maxConcurrentCount: Option[MaxConcurrentCount] = scala
      .Option(impl.maxConcurrentCount())
      .map(value =>
        zio.aws.cloudformation.model.primitives.MaxConcurrentCount(value)
      )
    override val maxConcurrentPercentage: Option[MaxConcurrentPercentage] =
      scala
        .Option(impl.maxConcurrentPercentage())
        .map(value =>
          zio.aws.cloudformation.model.primitives.MaxConcurrentPercentage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetOperationPreferences
  ): zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly =
    new Wrapper(impl)
}
