package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  StackSetARN,
  StackSetName,
  StackSetId,
  RoleARN,
  Description,
  ExecutionRoleName,
  TemplateBody,
  OrganizationalUnitId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StackSet(
    stackSetName: Option[StackSetName] = None,
    stackSetId: Option[StackSetId] = None,
    description: Option[Description] = None,
    status: Option[zio.aws.cloudformation.model.StackSetStatus] = None,
    templateBody: Option[TemplateBody] = None,
    parameters: Option[Iterable[zio.aws.cloudformation.model.Parameter]] = None,
    capabilities: Option[Iterable[zio.aws.cloudformation.model.Capability]] =
      None,
    tags: Option[Iterable[zio.aws.cloudformation.model.Tag]] = None,
    stackSetARN: Option[StackSetARN] = None,
    administrationRoleARN: Option[RoleARN] = None,
    executionRoleName: Option[ExecutionRoleName] = None,
    stackSetDriftDetectionDetails: Option[
      zio.aws.cloudformation.model.StackSetDriftDetectionDetails
    ] = None,
    autoDeployment: Option[zio.aws.cloudformation.model.AutoDeployment] = None,
    permissionModel: Option[zio.aws.cloudformation.model.PermissionModels] =
      None,
    organizationalUnitIds: Option[Iterable[OrganizationalUnitId]] = None,
    managedExecution: Option[zio.aws.cloudformation.model.ManagedExecution] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackSet = {
    import StackSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackSet
      .builder()
      .optionallyWith(
        stackSetName.map(value => StackSetName.unwrap(value): java.lang.String)
      )(_.stackSetName)
      .optionallyWith(
        stackSetId.map(value => StackSetId.unwrap(value): java.lang.String)
      )(_.stackSetId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        stackSetARN.map(value => StackSetARN.unwrap(value): java.lang.String)
      )(_.stackSetARN)
      .optionallyWith(
        administrationRoleARN.map(value =>
          RoleARN.unwrap(value): java.lang.String
        )
      )(_.administrationRoleARN)
      .optionallyWith(
        executionRoleName.map(value =>
          ExecutionRoleName.unwrap(value): java.lang.String
        )
      )(_.executionRoleName)
      .optionallyWith(
        stackSetDriftDetectionDetails.map(value => value.buildAwsValue())
      )(_.stackSetDriftDetectionDetails)
      .optionallyWith(autoDeployment.map(value => value.buildAwsValue()))(
        _.autoDeployment
      )
      .optionallyWith(permissionModel.map(value => value.unwrap))(
        _.permissionModel
      )
      .optionallyWith(
        organizationalUnitIds.map(value =>
          value.map { item =>
            OrganizationalUnitId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationalUnitIds)
      .optionallyWith(managedExecution.map(value => value.buildAwsValue()))(
        _.managedExecution
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.StackSet.ReadOnly =
    zio.aws.cloudformation.model.StackSet.wrap(buildAwsValue())
}
object StackSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackSet =
      zio.aws.cloudformation.model.StackSet(
        stackSetName.map(value => value),
        stackSetId.map(value => value),
        description.map(value => value),
        status.map(value => value),
        templateBody.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        capabilities.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stackSetARN.map(value => value),
        administrationRoleARN.map(value => value),
        executionRoleName.map(value => value),
        stackSetDriftDetectionDetails.map(value => value.asEditable),
        autoDeployment.map(value => value.asEditable),
        permissionModel.map(value => value),
        organizationalUnitIds.map(value => value),
        managedExecution.map(value => value.asEditable)
      )
    def stackSetName: Option[StackSetName]
    def stackSetId: Option[StackSetId]
    def description: Option[Description]
    def status: Option[zio.aws.cloudformation.model.StackSetStatus]
    def templateBody: Option[TemplateBody]
    def parameters
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def capabilities: Option[List[zio.aws.cloudformation.model.Capability]]
    def tags: Option[List[zio.aws.cloudformation.model.Tag.ReadOnly]]
    def stackSetARN: Option[StackSetARN]
    def administrationRoleARN: Option[RoleARN]
    def executionRoleName: Option[ExecutionRoleName]
    def stackSetDriftDetectionDetails: Option[
      zio.aws.cloudformation.model.StackSetDriftDetectionDetails.ReadOnly
    ]
    def autoDeployment
        : Option[zio.aws.cloudformation.model.AutoDeployment.ReadOnly]
    def permissionModel: Option[zio.aws.cloudformation.model.PermissionModels]
    def organizationalUnitIds: Option[List[OrganizationalUnitId]]
    def managedExecution
        : Option[zio.aws.cloudformation.model.ManagedExecution.ReadOnly]
    def getStackSetName: ZIO[Any, AwsError, StackSetName] =
      AwsError.unwrapOptionField("stackSetName", stackSetName)
    def getStackSetId: ZIO[Any, AwsError, StackSetId] =
      AwsError.unwrapOptionField("stackSetId", stackSetId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.StackSetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Capability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStackSetARN: ZIO[Any, AwsError, StackSetARN] =
      AwsError.unwrapOptionField("stackSetARN", stackSetARN)
    def getAdministrationRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("administrationRoleARN", administrationRoleARN)
    def getExecutionRoleName: ZIO[Any, AwsError, ExecutionRoleName] =
      AwsError.unwrapOptionField("executionRoleName", executionRoleName)
    def getStackSetDriftDetectionDetails: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetDriftDetectionDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "stackSetDriftDetectionDetails",
      stackSetDriftDetectionDetails
    )
    def getAutoDeployment: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.AutoDeployment.ReadOnly
    ] = AwsError.unwrapOptionField("autoDeployment", autoDeployment)
    def getPermissionModel
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.PermissionModels] =
      AwsError.unwrapOptionField("permissionModel", permissionModel)
    def getOrganizationalUnitIds
        : ZIO[Any, AwsError, List[OrganizationalUnitId]] =
      AwsError.unwrapOptionField("organizationalUnitIds", organizationalUnitIds)
    def getManagedExecution: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.ManagedExecution.ReadOnly
    ] = AwsError.unwrapOptionField("managedExecution", managedExecution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSet
  ) extends zio.aws.cloudformation.model.StackSet.ReadOnly {
    override val stackSetName: Option[StackSetName] = scala
      .Option(impl.stackSetName())
      .map(value => zio.aws.cloudformation.model.primitives.StackSetName(value))
    override val stackSetId: Option[StackSetId] = scala
      .Option(impl.stackSetId())
      .map(value => zio.aws.cloudformation.model.primitives.StackSetId(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val status: Option[zio.aws.cloudformation.model.StackSetStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.cloudformation.model.StackSetStatus.wrap(value))
    override val templateBody: Option[TemplateBody] = scala
      .Option(impl.templateBody())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateBody(value))
    override val parameters
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Parameter.wrap(item)
        }.toList
      )
    override val capabilities
        : Option[List[zio.aws.cloudformation.model.Capability]] = scala
      .Option(impl.capabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Capability.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Tag.wrap(item)
          }.toList
        )
    override val stackSetARN: Option[StackSetARN] = scala
      .Option(impl.stackSetARN())
      .map(value => zio.aws.cloudformation.model.primitives.StackSetARN(value))
    override val administrationRoleARN: Option[RoleARN] = scala
      .Option(impl.administrationRoleARN())
      .map(value => zio.aws.cloudformation.model.primitives.RoleARN(value))
    override val executionRoleName: Option[ExecutionRoleName] = scala
      .Option(impl.executionRoleName())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ExecutionRoleName(value)
      )
    override val stackSetDriftDetectionDetails: Option[
      zio.aws.cloudformation.model.StackSetDriftDetectionDetails.ReadOnly
    ] = scala
      .Option(impl.stackSetDriftDetectionDetails())
      .map(value =>
        zio.aws.cloudformation.model.StackSetDriftDetectionDetails.wrap(value)
      )
    override val autoDeployment
        : Option[zio.aws.cloudformation.model.AutoDeployment.ReadOnly] = scala
      .Option(impl.autoDeployment())
      .map(value => zio.aws.cloudformation.model.AutoDeployment.wrap(value))
    override val permissionModel
        : Option[zio.aws.cloudformation.model.PermissionModels] = scala
      .Option(impl.permissionModel())
      .map(value => zio.aws.cloudformation.model.PermissionModels.wrap(value))
    override val organizationalUnitIds: Option[List[OrganizationalUnitId]] =
      scala
        .Option(impl.organizationalUnitIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.OrganizationalUnitId(item)
          }.toList
        )
    override val managedExecution
        : Option[zio.aws.cloudformation.model.ManagedExecution.ReadOnly] = scala
      .Option(impl.managedExecution())
      .map(value => zio.aws.cloudformation.model.ManagedExecution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSet
  ): zio.aws.cloudformation.model.StackSet.ReadOnly = new Wrapper(impl)
}
