package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  LogicalResourceId,
  StackName,
  Timestamp,
  StackId,
  ResourceStatusReason,
  PhysicalResourceId,
  ResourceType,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StackResource(
    stackName: Option[StackName] = None,
    stackId: Option[StackId] = None,
    logicalResourceId: LogicalResourceId,
    physicalResourceId: Option[PhysicalResourceId] = None,
    resourceType: ResourceType,
    timestamp: Timestamp,
    resourceStatus: zio.aws.cloudformation.model.ResourceStatus,
    resourceStatusReason: Option[ResourceStatusReason] = None,
    description: Option[Description] = None,
    driftInformation: Option[
      zio.aws.cloudformation.model.StackResourceDriftInformation
    ] = None,
    moduleInfo: Option[zio.aws.cloudformation.model.ModuleInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackResource = {
    import StackResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackResource
      .builder()
      .optionallyWith(
        stackName.map(value => StackName.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .logicalResourceId(
        LogicalResourceId.unwrap(logicalResourceId): java.lang.String
      )
      .optionallyWith(
        physicalResourceId.map(value =>
          PhysicalResourceId.unwrap(value): java.lang.String
        )
      )(_.physicalResourceId)
      .resourceType(ResourceType.unwrap(resourceType): java.lang.String)
      .timestamp(Timestamp.unwrap(timestamp): Instant)
      .resourceStatus(resourceStatus.unwrap)
      .optionallyWith(
        resourceStatusReason.map(value =>
          ResourceStatusReason.unwrap(value): java.lang.String
        )
      )(_.resourceStatusReason)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(driftInformation.map(value => value.buildAwsValue()))(
        _.driftInformation
      )
      .optionallyWith(moduleInfo.map(value => value.buildAwsValue()))(
        _.moduleInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.StackResource.ReadOnly =
    zio.aws.cloudformation.model.StackResource.wrap(buildAwsValue())
}
object StackResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackResource =
      zio.aws.cloudformation.model.StackResource(
        stackName.map(value => value),
        stackId.map(value => value),
        logicalResourceId,
        physicalResourceId.map(value => value),
        resourceType,
        timestamp,
        resourceStatus,
        resourceStatusReason.map(value => value),
        description.map(value => value),
        driftInformation.map(value => value.asEditable),
        moduleInfo.map(value => value.asEditable)
      )
    def stackName: Option[StackName]
    def stackId: Option[StackId]
    def logicalResourceId: LogicalResourceId
    def physicalResourceId: Option[PhysicalResourceId]
    def resourceType: ResourceType
    def timestamp: Timestamp
    def resourceStatus: zio.aws.cloudformation.model.ResourceStatus
    def resourceStatusReason: Option[ResourceStatusReason]
    def description: Option[Description]
    def driftInformation: Option[
      zio.aws.cloudformation.model.StackResourceDriftInformation.ReadOnly
    ]
    def moduleInfo: Option[zio.aws.cloudformation.model.ModuleInfo.ReadOnly]
    def getStackName: ZIO[Any, AwsError, StackName] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
    def getLogicalResourceId: ZIO[Any, Nothing, LogicalResourceId] =
      ZIO.succeed(logicalResourceId)
    def getPhysicalResourceId: ZIO[Any, AwsError, PhysicalResourceId] =
      AwsError.unwrapOptionField("physicalResourceId", physicalResourceId)
    def getResourceType: ZIO[Any, Nothing, ResourceType] =
      ZIO.succeed(resourceType)
    def getTimestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestamp)
    def getResourceStatus
        : ZIO[Any, Nothing, zio.aws.cloudformation.model.ResourceStatus] =
      ZIO.succeed(resourceStatus)
    def getResourceStatusReason: ZIO[Any, AwsError, ResourceStatusReason] =
      AwsError.unwrapOptionField("resourceStatusReason", resourceStatusReason)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDriftInformation: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackResourceDriftInformation.ReadOnly
    ] = AwsError.unwrapOptionField("driftInformation", driftInformation)
    def getModuleInfo
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ModuleInfo.ReadOnly] =
      AwsError.unwrapOptionField("moduleInfo", moduleInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackResource
  ) extends zio.aws.cloudformation.model.StackResource.ReadOnly {
    override val stackName: Option[StackName] = scala
      .Option(impl.stackName())
      .map(value => zio.aws.cloudformation.model.primitives.StackName(value))
    override val stackId: Option[StackId] = scala
      .Option(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val logicalResourceId: LogicalResourceId =
      zio.aws.cloudformation.model.primitives
        .LogicalResourceId(impl.logicalResourceId())
    override val physicalResourceId: Option[PhysicalResourceId] = scala
      .Option(impl.physicalResourceId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PhysicalResourceId(value)
      )
    override val resourceType: ResourceType =
      zio.aws.cloudformation.model.primitives.ResourceType(impl.resourceType())
    override val timestamp: Timestamp =
      zio.aws.cloudformation.model.primitives.Timestamp(impl.timestamp())
    override val resourceStatus: zio.aws.cloudformation.model.ResourceStatus =
      zio.aws.cloudformation.model.ResourceStatus.wrap(impl.resourceStatus())
    override val resourceStatusReason: Option[ResourceStatusReason] = scala
      .Option(impl.resourceStatusReason())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ResourceStatusReason(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val driftInformation: Option[
      zio.aws.cloudformation.model.StackResourceDriftInformation.ReadOnly
    ] = scala
      .Option(impl.driftInformation())
      .map(value =>
        zio.aws.cloudformation.model.StackResourceDriftInformation.wrap(value)
      )
    override val moduleInfo
        : Option[zio.aws.cloudformation.model.ModuleInfo.ReadOnly] = scala
      .Option(impl.moduleInfo())
      .map(value => zio.aws.cloudformation.model.ModuleInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackResource
  ): zio.aws.cloudformation.model.StackResource.ReadOnly = new Wrapper(impl)
}
