package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  Account,
  Timestamp,
  StackSetId,
  StackId,
  Region,
  OrganizationalUnitId,
  Reason
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StackInstance(
    stackSetId: Option[StackSetId] = None,
    region: Option[Region] = None,
    account: Option[Account] = None,
    stackId: Option[StackId] = None,
    parameterOverrides: Option[
      Iterable[zio.aws.cloudformation.model.Parameter]
    ] = None,
    status: Option[zio.aws.cloudformation.model.StackInstanceStatus] = None,
    stackInstanceStatus: Option[
      zio.aws.cloudformation.model.StackInstanceComprehensiveStatus
    ] = None,
    statusReason: Option[Reason] = None,
    organizationalUnitId: Option[OrganizationalUnitId] = None,
    driftStatus: Option[zio.aws.cloudformation.model.StackDriftStatus] = None,
    lastDriftCheckTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackInstance = {
    import StackInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackInstance
      .builder()
      .optionallyWith(
        stackSetId.map(value => StackSetId.unwrap(value): java.lang.String)
      )(_.stackSetId)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        account.map(value => Account.unwrap(value): java.lang.String)
      )(_.account)
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .optionallyWith(
        parameterOverrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterOverrides)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(stackInstanceStatus.map(value => value.buildAwsValue()))(
        _.stackInstanceStatus
      )
      .optionallyWith(
        statusReason.map(value => Reason.unwrap(value): java.lang.String)
      )(_.statusReason)
      .optionallyWith(
        organizationalUnitId.map(value =>
          OrganizationalUnitId.unwrap(value): java.lang.String
        )
      )(_.organizationalUnitId)
      .optionallyWith(driftStatus.map(value => value.unwrap))(_.driftStatus)
      .optionallyWith(
        lastDriftCheckTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastDriftCheckTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.StackInstance.ReadOnly =
    zio.aws.cloudformation.model.StackInstance.wrap(buildAwsValue())
}
object StackInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackInstance =
      zio.aws.cloudformation.model.StackInstance(
        stackSetId.map(value => value),
        region.map(value => value),
        account.map(value => value),
        stackId.map(value => value),
        parameterOverrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        stackInstanceStatus.map(value => value.asEditable),
        statusReason.map(value => value),
        organizationalUnitId.map(value => value),
        driftStatus.map(value => value),
        lastDriftCheckTimestamp.map(value => value)
      )
    def stackSetId: Option[StackSetId]
    def region: Option[Region]
    def account: Option[Account]
    def stackId: Option[StackId]
    def parameterOverrides
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def status: Option[zio.aws.cloudformation.model.StackInstanceStatus]
    def stackInstanceStatus: Option[
      zio.aws.cloudformation.model.StackInstanceComprehensiveStatus.ReadOnly
    ]
    def statusReason: Option[Reason]
    def organizationalUnitId: Option[OrganizationalUnitId]
    def driftStatus: Option[zio.aws.cloudformation.model.StackDriftStatus]
    def lastDriftCheckTimestamp: Option[Timestamp]
    def getStackSetId: ZIO[Any, AwsError, StackSetId] =
      AwsError.unwrapOptionField("stackSetId", stackSetId)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getAccount: ZIO[Any, AwsError, Account] =
      AwsError.unwrapOptionField("account", account)
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
    def getParameterOverrides: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterOverrides", parameterOverrides)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.StackInstanceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStackInstanceStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackInstanceComprehensiveStatus.ReadOnly
    ] = AwsError.unwrapOptionField("stackInstanceStatus", stackInstanceStatus)
    def getStatusReason: ZIO[Any, AwsError, Reason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getOrganizationalUnitId: ZIO[Any, AwsError, OrganizationalUnitId] =
      AwsError.unwrapOptionField("organizationalUnitId", organizationalUnitId)
    def getDriftStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.StackDriftStatus] =
      AwsError.unwrapOptionField("driftStatus", driftStatus)
    def getLastDriftCheckTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastDriftCheckTimestamp", lastDriftCheckTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackInstance
  ) extends zio.aws.cloudformation.model.StackInstance.ReadOnly {
    override val stackSetId: Option[StackSetId] = scala
      .Option(impl.stackSetId())
      .map(value => zio.aws.cloudformation.model.primitives.StackSetId(value))
    override val region: Option[Region] = scala
      .Option(impl.region())
      .map(value => zio.aws.cloudformation.model.primitives.Region(value))
    override val account: Option[Account] = scala
      .Option(impl.account())
      .map(value => zio.aws.cloudformation.model.primitives.Account(value))
    override val stackId: Option[StackId] = scala
      .Option(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val parameterOverrides
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameterOverrides())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Parameter.wrap(item)
        }.toList
      )
    override val status
        : Option[zio.aws.cloudformation.model.StackInstanceStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.cloudformation.model.StackInstanceStatus.wrap(value)
      )
    override val stackInstanceStatus: Option[
      zio.aws.cloudformation.model.StackInstanceComprehensiveStatus.ReadOnly
    ] = scala
      .Option(impl.stackInstanceStatus())
      .map(value =>
        zio.aws.cloudformation.model.StackInstanceComprehensiveStatus
          .wrap(value)
      )
    override val statusReason: Option[Reason] = scala
      .Option(impl.statusReason())
      .map(value => zio.aws.cloudformation.model.primitives.Reason(value))
    override val organizationalUnitId: Option[OrganizationalUnitId] = scala
      .Option(impl.organizationalUnitId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.OrganizationalUnitId(value)
      )
    override val driftStatus
        : Option[zio.aws.cloudformation.model.StackDriftStatus] = scala
      .Option(impl.driftStatus())
      .map(value => zio.aws.cloudformation.model.StackDriftStatus.wrap(value))
    override val lastDriftCheckTimestamp: Option[Timestamp] = scala
      .Option(impl.lastDriftCheckTimestamp())
      .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackInstance
  ): zio.aws.cloudformation.model.StackInstance.ReadOnly = new Wrapper(impl)
}
