package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ResourceIdentifierPropertyKey,
  LogicalResourceId,
  ResourceType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResourceIdentifierSummary(
    resourceType: Option[ResourceType] = None,
    logicalResourceIds: Option[Iterable[LogicalResourceId]] = None,
    resourceIdentifiers: Option[Iterable[ResourceIdentifierPropertyKey]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ResourceIdentifierSummary = {
    import ResourceIdentifierSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ResourceIdentifierSummary
      .builder()
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(
        logicalResourceIds.map(value =>
          value.map { item =>
            LogicalResourceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.logicalResourceIds)
      .optionallyWith(
        resourceIdentifiers.map(value =>
          value.map { item =>
            ResourceIdentifierPropertyKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceIdentifiers)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ResourceIdentifierSummary.ReadOnly =
    zio.aws.cloudformation.model.ResourceIdentifierSummary.wrap(buildAwsValue())
}
object ResourceIdentifierSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ResourceIdentifierSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ResourceIdentifierSummary =
      zio.aws.cloudformation.model.ResourceIdentifierSummary(
        resourceType.map(value => value),
        logicalResourceIds.map(value => value),
        resourceIdentifiers.map(value => value)
      )
    def resourceType: Option[ResourceType]
    def logicalResourceIds: Option[List[LogicalResourceId]]
    def resourceIdentifiers: Option[List[ResourceIdentifierPropertyKey]]
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getLogicalResourceIds: ZIO[Any, AwsError, List[LogicalResourceId]] =
      AwsError.unwrapOptionField("logicalResourceIds", logicalResourceIds)
    def getResourceIdentifiers
        : ZIO[Any, AwsError, List[ResourceIdentifierPropertyKey]] =
      AwsError.unwrapOptionField("resourceIdentifiers", resourceIdentifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ResourceIdentifierSummary
  ) extends zio.aws.cloudformation.model.ResourceIdentifierSummary.ReadOnly {
    override val resourceType: Option[ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.cloudformation.model.primitives.ResourceType(value))
    override val logicalResourceIds: Option[List[LogicalResourceId]] = scala
      .Option(impl.logicalResourceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.LogicalResourceId(item)
        }.toList
      )
    override val resourceIdentifiers
        : Option[List[ResourceIdentifierPropertyKey]] = scala
      .Option(impl.resourceIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives
            .ResourceIdentifierPropertyKey(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ResourceIdentifierSummary
  ): zio.aws.cloudformation.model.ResourceIdentifierSummary.ReadOnly =
    new Wrapper(impl)
}
