package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.CausingEntity
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResourceChangeDetail(
    target: Option[zio.aws.cloudformation.model.ResourceTargetDefinition] =
      None,
    evaluation: Option[zio.aws.cloudformation.model.EvaluationType] = None,
    changeSource: Option[zio.aws.cloudformation.model.ChangeSource] = None,
    causingEntity: Option[CausingEntity] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ResourceChangeDetail = {
    import ResourceChangeDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ResourceChangeDetail
      .builder()
      .optionallyWith(target.map(value => value.buildAwsValue()))(_.target)
      .optionallyWith(evaluation.map(value => value.unwrap))(_.evaluation)
      .optionallyWith(changeSource.map(value => value.unwrap))(_.changeSource)
      .optionallyWith(
        causingEntity.map(value =>
          CausingEntity.unwrap(value): java.lang.String
        )
      )(_.causingEntity)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ResourceChangeDetail.ReadOnly =
    zio.aws.cloudformation.model.ResourceChangeDetail.wrap(buildAwsValue())
}
object ResourceChangeDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ResourceChangeDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ResourceChangeDetail =
      zio.aws.cloudformation.model.ResourceChangeDetail(
        target.map(value => value.asEditable),
        evaluation.map(value => value),
        changeSource.map(value => value),
        causingEntity.map(value => value)
      )
    def target
        : Option[zio.aws.cloudformation.model.ResourceTargetDefinition.ReadOnly]
    def evaluation: Option[zio.aws.cloudformation.model.EvaluationType]
    def changeSource: Option[zio.aws.cloudformation.model.ChangeSource]
    def causingEntity: Option[CausingEntity]
    def getTarget: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.ResourceTargetDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("target", target)
    def getEvaluation
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.EvaluationType] =
      AwsError.unwrapOptionField("evaluation", evaluation)
    def getChangeSource
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ChangeSource] =
      AwsError.unwrapOptionField("changeSource", changeSource)
    def getCausingEntity: ZIO[Any, AwsError, CausingEntity] =
      AwsError.unwrapOptionField("causingEntity", causingEntity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ResourceChangeDetail
  ) extends zio.aws.cloudformation.model.ResourceChangeDetail.ReadOnly {
    override val target: Option[
      zio.aws.cloudformation.model.ResourceTargetDefinition.ReadOnly
    ] = scala
      .Option(impl.target())
      .map(value =>
        zio.aws.cloudformation.model.ResourceTargetDefinition.wrap(value)
      )
    override val evaluation
        : Option[zio.aws.cloudformation.model.EvaluationType] = scala
      .Option(impl.evaluation())
      .map(value => zio.aws.cloudformation.model.EvaluationType.wrap(value))
    override val changeSource
        : Option[zio.aws.cloudformation.model.ChangeSource] = scala
      .Option(impl.changeSource())
      .map(value => zio.aws.cloudformation.model.ChangeSource.wrap(value))
    override val causingEntity: Option[CausingEntity] = scala
      .Option(impl.causingEntity())
      .map(value =>
        zio.aws.cloudformation.model.primitives.CausingEntity(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ResourceChangeDetail
  ): zio.aws.cloudformation.model.ResourceChangeDetail.ReadOnly = new Wrapper(
    impl
  )
}
