package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  RequestToken,
  RoleArn,
  S3Url,
  TypeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RegisterTypeRequest(
    `type`: Option[zio.aws.cloudformation.model.RegistryType] = None,
    typeName: TypeName,
    schemaHandlerPackage: S3Url,
    loggingConfig: Option[zio.aws.cloudformation.model.LoggingConfig] = None,
    executionRoleArn: Option[RoleArn] = None,
    clientRequestToken: Option[RequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.RegisterTypeRequest = {
    import RegisterTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.RegisterTypeRequest
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .typeName(TypeName.unwrap(typeName): java.lang.String)
      .schemaHandlerPackage(
        S3Url.unwrap(schemaHandlerPackage): java.lang.String
      )
      .optionallyWith(loggingConfig.map(value => value.buildAwsValue()))(
        _.loggingConfig
      )
      .optionallyWith(
        executionRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.executionRoleArn)
      .optionallyWith(
        clientRequestToken.map(value =>
          RequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.RegisterTypeRequest.ReadOnly =
    zio.aws.cloudformation.model.RegisterTypeRequest.wrap(buildAwsValue())
}
object RegisterTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.RegisterTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.RegisterTypeRequest =
      zio.aws.cloudformation.model.RegisterTypeRequest(
        `type`.map(value => value),
        typeName,
        schemaHandlerPackage,
        loggingConfig.map(value => value.asEditable),
        executionRoleArn.map(value => value),
        clientRequestToken.map(value => value)
      )
    def `type`: Option[zio.aws.cloudformation.model.RegistryType]
    def typeName: TypeName
    def schemaHandlerPackage: S3Url
    def loggingConfig
        : Option[zio.aws.cloudformation.model.LoggingConfig.ReadOnly]
    def executionRoleArn: Option[RoleArn]
    def clientRequestToken: Option[RequestToken]
    def getType: ZIO[Any, AwsError, zio.aws.cloudformation.model.RegistryType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTypeName: ZIO[Any, Nothing, TypeName] = ZIO.succeed(typeName)
    def getSchemaHandlerPackage: ZIO[Any, Nothing, S3Url] =
      ZIO.succeed(schemaHandlerPackage)
    def getLoggingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.LoggingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfig", loggingConfig)
    def getExecutionRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getClientRequestToken: ZIO[Any, AwsError, RequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.RegisterTypeRequest
  ) extends zio.aws.cloudformation.model.RegisterTypeRequest.ReadOnly {
    override val `type`: Option[zio.aws.cloudformation.model.RegistryType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.cloudformation.model.RegistryType.wrap(value))
    override val typeName: TypeName =
      zio.aws.cloudformation.model.primitives.TypeName(impl.typeName())
    override val schemaHandlerPackage: S3Url =
      zio.aws.cloudformation.model.primitives.S3Url(impl.schemaHandlerPackage())
    override val loggingConfig
        : Option[zio.aws.cloudformation.model.LoggingConfig.ReadOnly] = scala
      .Option(impl.loggingConfig())
      .map(value => zio.aws.cloudformation.model.LoggingConfig.wrap(value))
    override val executionRoleArn: Option[RoleArn] = scala
      .Option(impl.executionRoleArn())
      .map(value => zio.aws.cloudformation.model.primitives.RoleArn(value))
    override val clientRequestToken: Option[RequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.cloudformation.model.primitives.RequestToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.RegisterTypeRequest
  ): zio.aws.cloudformation.model.RegisterTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
