package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.TypeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PublishTypeResponse(publicTypeArn: Option[TypeArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.PublishTypeResponse = {
    import PublishTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.PublishTypeResponse
      .builder()
      .optionallyWith(
        publicTypeArn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.publicTypeArn)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.PublishTypeResponse.ReadOnly =
    zio.aws.cloudformation.model.PublishTypeResponse.wrap(buildAwsValue())
}
object PublishTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.PublishTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.PublishTypeResponse =
      zio.aws.cloudformation.model
        .PublishTypeResponse(publicTypeArn.map(value => value))
    def publicTypeArn: Option[TypeArn]
    def getPublicTypeArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("publicTypeArn", publicTypeArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.PublishTypeResponse
  ) extends zio.aws.cloudformation.model.PublishTypeResponse.ReadOnly {
    override val publicTypeArn: Option[TypeArn] = scala
      .Option(impl.publicTypeArn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.PublishTypeResponse
  ): zio.aws.cloudformation.model.PublishTypeResponse.ReadOnly = new Wrapper(
    impl
  )
}
