package zio.aws.cloudformation.model
import java.lang.Integer
import zio.aws.cloudformation.model.primitives.{
  NextToken,
  PublisherId,
  TypeArn,
  MaxResults,
  TypeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTypeVersionsRequest(
    `type`: Option[zio.aws.cloudformation.model.RegistryType] = None,
    typeName: Option[TypeName] = None,
    arn: Option[TypeArn] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    deprecatedStatus: Option[zio.aws.cloudformation.model.DeprecatedStatus] =
      None,
    publisherId: Option[PublisherId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest = {
    import ListTypeVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        arn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(deprecatedStatus.map(value => value.unwrap))(
        _.deprecatedStatus
      )
      .optionallyWith(
        publisherId.map(value => PublisherId.unwrap(value): java.lang.String)
      )(_.publisherId)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ListTypeVersionsRequest.ReadOnly =
    zio.aws.cloudformation.model.ListTypeVersionsRequest.wrap(buildAwsValue())
}
object ListTypeVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListTypeVersionsRequest =
      zio.aws.cloudformation.model.ListTypeVersionsRequest(
        `type`.map(value => value),
        typeName.map(value => value),
        arn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        deprecatedStatus.map(value => value),
        publisherId.map(value => value)
      )
    def `type`: Option[zio.aws.cloudformation.model.RegistryType]
    def typeName: Option[TypeName]
    def arn: Option[TypeArn]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def deprecatedStatus: Option[zio.aws.cloudformation.model.DeprecatedStatus]
    def publisherId: Option[PublisherId]
    def getType: ZIO[Any, AwsError, zio.aws.cloudformation.model.RegistryType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDeprecatedStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.DeprecatedStatus] =
      AwsError.unwrapOptionField("deprecatedStatus", deprecatedStatus)
    def getPublisherId: ZIO[Any, AwsError, PublisherId] =
      AwsError.unwrapOptionField("publisherId", publisherId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest
  ) extends zio.aws.cloudformation.model.ListTypeVersionsRequest.ReadOnly {
    override val `type`: Option[zio.aws.cloudformation.model.RegistryType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.cloudformation.model.RegistryType.wrap(value))
    override val typeName: Option[TypeName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val arn: Option[TypeArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.cloudformation.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
    override val deprecatedStatus
        : Option[zio.aws.cloudformation.model.DeprecatedStatus] = scala
      .Option(impl.deprecatedStatus())
      .map(value => zio.aws.cloudformation.model.DeprecatedStatus.wrap(value))
    override val publisherId: Option[PublisherId] = scala
      .Option(impl.publisherId())
      .map(value => zio.aws.cloudformation.model.primitives.PublisherId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest
  ): zio.aws.cloudformation.model.ListTypeVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
