package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListStacksResponse(
    stackSummaries: Option[
      Iterable[zio.aws.cloudformation.model.StackSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListStacksResponse = {
    import ListStacksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListStacksResponse
      .builder()
      .optionallyWith(
        stackSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stackSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ListStacksResponse.ReadOnly =
    zio.aws.cloudformation.model.ListStacksResponse.wrap(buildAwsValue())
}
object ListStacksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListStacksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListStacksResponse =
      zio.aws.cloudformation.model.ListStacksResponse(
        stackSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def stackSummaries
        : Option[List[zio.aws.cloudformation.model.StackSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getStackSummaries: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.StackSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("stackSummaries", stackSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStacksResponse
  ) extends zio.aws.cloudformation.model.ListStacksResponse.ReadOnly {
    override val stackSummaries
        : Option[List[zio.aws.cloudformation.model.StackSummary.ReadOnly]] =
      scala
        .Option(impl.stackSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.StackSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStacksResponse
  ): zio.aws.cloudformation.model.ListStacksResponse.ReadOnly = new Wrapper(
    impl
  )
}
