package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  CreationTime,
  NextToken,
  ChangeSetName,
  StackName,
  NotificationARN,
  IncludeNestedStacks,
  StackId,
  Description,
  ChangeSetId,
  ChangeSetStatusReason
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeChangeSetResponse(
    changeSetName: Option[ChangeSetName] = None,
    changeSetId: Option[ChangeSetId] = None,
    stackId: Option[StackId] = None,
    stackName: Option[StackName] = None,
    description: Option[Description] = None,
    parameters: Option[Iterable[zio.aws.cloudformation.model.Parameter]] = None,
    creationTime: Option[CreationTime] = None,
    executionStatus: Option[zio.aws.cloudformation.model.ExecutionStatus] =
      None,
    status: Option[zio.aws.cloudformation.model.ChangeSetStatus] = None,
    statusReason: Option[ChangeSetStatusReason] = None,
    notificationARNs: Option[Iterable[NotificationARN]] = None,
    rollbackConfiguration: Option[
      zio.aws.cloudformation.model.RollbackConfiguration
    ] = None,
    capabilities: Option[Iterable[zio.aws.cloudformation.model.Capability]] =
      None,
    tags: Option[Iterable[zio.aws.cloudformation.model.Tag]] = None,
    changes: Option[Iterable[zio.aws.cloudformation.model.Change]] = None,
    nextToken: Option[NextToken] = None,
    includeNestedStacks: Option[IncludeNestedStacks] = None,
    parentChangeSetId: Option[ChangeSetId] = None,
    rootChangeSetId: Option[ChangeSetId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse = {
    import DescribeChangeSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse
      .builder()
      .optionallyWith(
        changeSetName.map(value =>
          ChangeSetName.unwrap(value): java.lang.String
        )
      )(_.changeSetName)
      .optionallyWith(
        changeSetId.map(value => ChangeSetId.unwrap(value): java.lang.String)
      )(_.changeSetId)
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .optionallyWith(
        stackName.map(value => StackName.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(executionStatus.map(value => value.unwrap))(
        _.executionStatus
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusReason.map(value =>
          ChangeSetStatusReason.unwrap(value): java.lang.String
        )
      )(_.statusReason)
      .optionallyWith(
        notificationARNs.map(value =>
          value.map { item =>
            NotificationARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.notificationARNs)
      .optionallyWith(
        rollbackConfiguration.map(value => value.buildAwsValue())
      )(_.rollbackConfiguration)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        changes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.changes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        includeNestedStacks.map(value =>
          IncludeNestedStacks.unwrap(value): java.lang.Boolean
        )
      )(_.includeNestedStacks)
      .optionallyWith(
        parentChangeSetId.map(value =>
          ChangeSetId.unwrap(value): java.lang.String
        )
      )(_.parentChangeSetId)
      .optionallyWith(
        rootChangeSetId.map(value =>
          ChangeSetId.unwrap(value): java.lang.String
        )
      )(_.rootChangeSetId)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeChangeSetResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeChangeSetResponse.wrap(buildAwsValue())
}
object DescribeChangeSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeChangeSetResponse =
      zio.aws.cloudformation.model.DescribeChangeSetResponse(
        changeSetName.map(value => value),
        changeSetId.map(value => value),
        stackId.map(value => value),
        stackName.map(value => value),
        description.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTime.map(value => value),
        executionStatus.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        notificationARNs.map(value => value),
        rollbackConfiguration.map(value => value.asEditable),
        capabilities.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        changes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        includeNestedStacks.map(value => value),
        parentChangeSetId.map(value => value),
        rootChangeSetId.map(value => value)
      )
    def changeSetName: Option[ChangeSetName]
    def changeSetId: Option[ChangeSetId]
    def stackId: Option[StackId]
    def stackName: Option[StackName]
    def description: Option[Description]
    def parameters
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def creationTime: Option[CreationTime]
    def executionStatus: Option[zio.aws.cloudformation.model.ExecutionStatus]
    def status: Option[zio.aws.cloudformation.model.ChangeSetStatus]
    def statusReason: Option[ChangeSetStatusReason]
    def notificationARNs: Option[List[NotificationARN]]
    def rollbackConfiguration
        : Option[zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly]
    def capabilities: Option[List[zio.aws.cloudformation.model.Capability]]
    def tags: Option[List[zio.aws.cloudformation.model.Tag.ReadOnly]]
    def changes: Option[List[zio.aws.cloudformation.model.Change.ReadOnly]]
    def nextToken: Option[NextToken]
    def includeNestedStacks: Option[IncludeNestedStacks]
    def parentChangeSetId: Option[ChangeSetId]
    def rootChangeSetId: Option[ChangeSetId]
    def getChangeSetName: ZIO[Any, AwsError, ChangeSetName] =
      AwsError.unwrapOptionField("changeSetName", changeSetName)
    def getChangeSetId: ZIO[Any, AwsError, ChangeSetId] =
      AwsError.unwrapOptionField("changeSetId", changeSetId)
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
    def getStackName: ZIO[Any, AwsError, StackName] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getExecutionStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ExecutionStatus] =
      AwsError.unwrapOptionField("executionStatus", executionStatus)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ChangeSetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, ChangeSetStatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getNotificationARNs: ZIO[Any, AwsError, List[NotificationARN]] =
      AwsError.unwrapOptionField("notificationARNs", notificationARNs)
    def getRollbackConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("rollbackConfiguration", rollbackConfiguration)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Capability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getChanges: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Change.ReadOnly
    ]] = AwsError.unwrapOptionField("changes", changes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getIncludeNestedStacks: ZIO[Any, AwsError, IncludeNestedStacks] =
      AwsError.unwrapOptionField("includeNestedStacks", includeNestedStacks)
    def getParentChangeSetId: ZIO[Any, AwsError, ChangeSetId] =
      AwsError.unwrapOptionField("parentChangeSetId", parentChangeSetId)
    def getRootChangeSetId: ZIO[Any, AwsError, ChangeSetId] =
      AwsError.unwrapOptionField("rootChangeSetId", rootChangeSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse
  ) extends zio.aws.cloudformation.model.DescribeChangeSetResponse.ReadOnly {
    override val changeSetName: Option[ChangeSetName] = scala
      .Option(impl.changeSetName())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ChangeSetName(value)
      )
    override val changeSetId: Option[ChangeSetId] = scala
      .Option(impl.changeSetId())
      .map(value => zio.aws.cloudformation.model.primitives.ChangeSetId(value))
    override val stackId: Option[StackId] = scala
      .Option(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val stackName: Option[StackName] = scala
      .Option(impl.stackName())
      .map(value => zio.aws.cloudformation.model.primitives.StackName(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val parameters
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Parameter.wrap(item)
        }.toList
      )
    override val creationTime: Option[CreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.cloudformation.model.primitives.CreationTime(value))
    override val executionStatus
        : Option[zio.aws.cloudformation.model.ExecutionStatus] = scala
      .Option(impl.executionStatus())
      .map(value => zio.aws.cloudformation.model.ExecutionStatus.wrap(value))
    override val status: Option[zio.aws.cloudformation.model.ChangeSetStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.cloudformation.model.ChangeSetStatus.wrap(value))
    override val statusReason: Option[ChangeSetStatusReason] = scala
      .Option(impl.statusReason())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ChangeSetStatusReason(value)
      )
    override val notificationARNs: Option[List[NotificationARN]] = scala
      .Option(impl.notificationARNs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.NotificationARN(item)
        }.toList
      )
    override val rollbackConfiguration
        : Option[zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly] =
      scala
        .Option(impl.rollbackConfiguration())
        .map(value =>
          zio.aws.cloudformation.model.RollbackConfiguration.wrap(value)
        )
    override val capabilities
        : Option[List[zio.aws.cloudformation.model.Capability]] = scala
      .Option(impl.capabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Capability.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Tag.wrap(item)
          }.toList
        )
    override val changes
        : Option[List[zio.aws.cloudformation.model.Change.ReadOnly]] = scala
      .Option(impl.changes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Change.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
    override val includeNestedStacks: Option[IncludeNestedStacks] = scala
      .Option(impl.includeNestedStacks())
      .map(value =>
        zio.aws.cloudformation.model.primitives.IncludeNestedStacks(value)
      )
    override val parentChangeSetId: Option[ChangeSetId] = scala
      .Option(impl.parentChangeSetId())
      .map(value => zio.aws.cloudformation.model.primitives.ChangeSetId(value))
    override val rootChangeSetId: Option[ChangeSetId] = scala
      .Option(impl.rootChangeSetId())
      .map(value => zio.aws.cloudformation.model.primitives.ChangeSetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse
  ): zio.aws.cloudformation.model.DescribeChangeSetResponse.ReadOnly =
    new Wrapper(impl)
}
