package zio.aws.cloudformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Change(
    `type`: Option[zio.aws.cloudformation.model.ChangeType] = None,
    resourceChange: Option[zio.aws.cloudformation.model.ResourceChange] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.Change = {
    import Change.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.Change
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(resourceChange.map(value => value.buildAwsValue()))(
        _.resourceChange
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.Change.ReadOnly =
    zio.aws.cloudformation.model.Change.wrap(buildAwsValue())
}
object Change {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.Change
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.Change =
      zio.aws.cloudformation.model.Change(
        `type`.map(value => value),
        resourceChange.map(value => value.asEditable)
      )
    def `type`: Option[zio.aws.cloudformation.model.ChangeType]
    def resourceChange
        : Option[zio.aws.cloudformation.model.ResourceChange.ReadOnly]
    def getType: ZIO[Any, AwsError, zio.aws.cloudformation.model.ChangeType] =
      AwsError.unwrapOptionField("type", `type`)
    def getResourceChange: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.ResourceChange.ReadOnly
    ] = AwsError.unwrapOptionField("resourceChange", resourceChange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.Change
  ) extends zio.aws.cloudformation.model.Change.ReadOnly {
    override val `type`: Option[zio.aws.cloudformation.model.ChangeType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.cloudformation.model.ChangeType.wrap(value))
    override val resourceChange
        : Option[zio.aws.cloudformation.model.ResourceChange.ReadOnly] = scala
      .Option(impl.resourceChange())
      .map(value => zio.aws.cloudformation.model.ResourceChange.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.Change
  ): zio.aws.cloudformation.model.Change.ReadOnly = new Wrapper(impl)
}
