package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{ClientRequestToken, StackName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CancelUpdateStackRequest(
    stackName: StackName,
    clientRequestToken: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackRequest = {
    import CancelUpdateStackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackRequest
      .builder()
      .stackName(StackName.unwrap(stackName): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.CancelUpdateStackRequest.ReadOnly =
    zio.aws.cloudformation.model.CancelUpdateStackRequest.wrap(buildAwsValue())
}
object CancelUpdateStackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.CancelUpdateStackRequest =
      zio.aws.cloudformation.model.CancelUpdateStackRequest(
        stackName,
        clientRequestToken.map(value => value)
      )
    def stackName: StackName
    def clientRequestToken: Option[ClientRequestToken]
    def getStackName: ZIO[Any, Nothing, StackName] = ZIO.succeed(stackName)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackRequest
  ) extends zio.aws.cloudformation.model.CancelUpdateStackRequest.ReadOnly {
    override val stackName: StackName =
      zio.aws.cloudformation.model.primitives.StackName(impl.stackName())
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackRequest
  ): zio.aws.cloudformation.model.CancelUpdateStackRequest.ReadOnly =
    new Wrapper(impl)
}
