package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  RetainStacksOnAccountRemovalNullable,
  AutoDeploymentNullable
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AutoDeployment(
    enabled: Option[AutoDeploymentNullable] = None,
    retainStacksOnAccountRemoval: Option[RetainStacksOnAccountRemovalNullable] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.AutoDeployment = {
    import AutoDeployment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.AutoDeployment
      .builder()
      .optionallyWith(
        enabled.map(value =>
          AutoDeploymentNullable.unwrap(value): java.lang.Boolean
        )
      )(_.enabled)
      .optionallyWith(
        retainStacksOnAccountRemoval.map(value =>
          RetainStacksOnAccountRemovalNullable.unwrap(value): java.lang.Boolean
        )
      )(_.retainStacksOnAccountRemoval)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.AutoDeployment.ReadOnly =
    zio.aws.cloudformation.model.AutoDeployment.wrap(buildAwsValue())
}
object AutoDeployment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.AutoDeployment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.AutoDeployment =
      zio.aws.cloudformation.model.AutoDeployment(
        enabled.map(value => value),
        retainStacksOnAccountRemoval.map(value => value)
      )
    def enabled: Option[AutoDeploymentNullable]
    def retainStacksOnAccountRemoval
        : Option[RetainStacksOnAccountRemovalNullable]
    def getEnabled: ZIO[Any, AwsError, AutoDeploymentNullable] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getRetainStacksOnAccountRemoval
        : ZIO[Any, AwsError, RetainStacksOnAccountRemovalNullable] =
      AwsError.unwrapOptionField(
        "retainStacksOnAccountRemoval",
        retainStacksOnAccountRemoval
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.AutoDeployment
  ) extends zio.aws.cloudformation.model.AutoDeployment.ReadOnly {
    override val enabled: Option[AutoDeploymentNullable] = scala
      .Option(impl.enabled())
      .map(value =>
        zio.aws.cloudformation.model.primitives.AutoDeploymentNullable(value)
      )
    override val retainStacksOnAccountRemoval
        : Option[RetainStacksOnAccountRemovalNullable] = scala
      .Option(impl.retainStacksOnAccountRemoval())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .RetainStacksOnAccountRemovalNullable(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.AutoDeployment
  ): zio.aws.cloudformation.model.AutoDeployment.ReadOnly = new Wrapper(impl)
}
