package zio.aws.cloudformation.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  TotalStackInstancesCount,
  FailedStackInstancesCount,
  Timestamp,
  DriftedStackInstancesCount,
  InProgressStackInstancesCount,
  InSyncStackInstancesCount
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StackSetDriftDetectionDetails(
    driftStatus: Option[zio.aws.cloudformation.model.StackSetDriftStatus] =
      None,
    driftDetectionStatus: Option[
      zio.aws.cloudformation.model.StackSetDriftDetectionStatus
    ] = None,
    lastDriftCheckTimestamp: Option[Timestamp] = None,
    totalStackInstancesCount: Option[TotalStackInstancesCount] = None,
    driftedStackInstancesCount: Option[DriftedStackInstancesCount] = None,
    inSyncStackInstancesCount: Option[InSyncStackInstancesCount] = None,
    inProgressStackInstancesCount: Option[InProgressStackInstancesCount] = None,
    failedStackInstancesCount: Option[FailedStackInstancesCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionDetails = {
    import StackSetDriftDetectionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionDetails
      .builder()
      .optionallyWith(driftStatus.map(value => value.unwrap))(_.driftStatus)
      .optionallyWith(driftDetectionStatus.map(value => value.unwrap))(
        _.driftDetectionStatus
      )
      .optionallyWith(
        lastDriftCheckTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastDriftCheckTimestamp)
      .optionallyWith(
        totalStackInstancesCount.map(value =>
          TotalStackInstancesCount.unwrap(value): Integer
        )
      )(_.totalStackInstancesCount)
      .optionallyWith(
        driftedStackInstancesCount.map(value =>
          DriftedStackInstancesCount.unwrap(value): Integer
        )
      )(_.driftedStackInstancesCount)
      .optionallyWith(
        inSyncStackInstancesCount.map(value =>
          InSyncStackInstancesCount.unwrap(value): Integer
        )
      )(_.inSyncStackInstancesCount)
      .optionallyWith(
        inProgressStackInstancesCount.map(value =>
          InProgressStackInstancesCount.unwrap(value): Integer
        )
      )(_.inProgressStackInstancesCount)
      .optionallyWith(
        failedStackInstancesCount.map(value =>
          FailedStackInstancesCount.unwrap(value): Integer
        )
      )(_.failedStackInstancesCount)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.StackSetDriftDetectionDetails.ReadOnly =
    zio.aws.cloudformation.model.StackSetDriftDetectionDetails
      .wrap(buildAwsValue())
}
object StackSetDriftDetectionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackSetDriftDetectionDetails =
      zio.aws.cloudformation.model.StackSetDriftDetectionDetails(
        driftStatus.map(value => value),
        driftDetectionStatus.map(value => value),
        lastDriftCheckTimestamp.map(value => value),
        totalStackInstancesCount.map(value => value),
        driftedStackInstancesCount.map(value => value),
        inSyncStackInstancesCount.map(value => value),
        inProgressStackInstancesCount.map(value => value),
        failedStackInstancesCount.map(value => value)
      )
    def driftStatus: Option[zio.aws.cloudformation.model.StackSetDriftStatus]
    def driftDetectionStatus
        : Option[zio.aws.cloudformation.model.StackSetDriftDetectionStatus]
    def lastDriftCheckTimestamp: Option[Timestamp]
    def totalStackInstancesCount: Option[TotalStackInstancesCount]
    def driftedStackInstancesCount: Option[DriftedStackInstancesCount]
    def inSyncStackInstancesCount: Option[InSyncStackInstancesCount]
    def inProgressStackInstancesCount: Option[InProgressStackInstancesCount]
    def failedStackInstancesCount: Option[FailedStackInstancesCount]
    def getDriftStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.StackSetDriftStatus] =
      AwsError.unwrapOptionField("driftStatus", driftStatus)
    def getDriftDetectionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetDriftDetectionStatus
    ] = AwsError.unwrapOptionField("driftDetectionStatus", driftDetectionStatus)
    def getLastDriftCheckTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastDriftCheckTimestamp", lastDriftCheckTimestamp)
    def getTotalStackInstancesCount
        : ZIO[Any, AwsError, TotalStackInstancesCount] = AwsError
      .unwrapOptionField("totalStackInstancesCount", totalStackInstancesCount)
    def getDriftedStackInstancesCount
        : ZIO[Any, AwsError, DriftedStackInstancesCount] =
      AwsError.unwrapOptionField(
        "driftedStackInstancesCount",
        driftedStackInstancesCount
      )
    def getInSyncStackInstancesCount
        : ZIO[Any, AwsError, InSyncStackInstancesCount] = AwsError
      .unwrapOptionField("inSyncStackInstancesCount", inSyncStackInstancesCount)
    def getInProgressStackInstancesCount
        : ZIO[Any, AwsError, InProgressStackInstancesCount] =
      AwsError.unwrapOptionField(
        "inProgressStackInstancesCount",
        inProgressStackInstancesCount
      )
    def getFailedStackInstancesCount
        : ZIO[Any, AwsError, FailedStackInstancesCount] = AwsError
      .unwrapOptionField("failedStackInstancesCount", failedStackInstancesCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionDetails
  ) extends zio.aws.cloudformation.model.StackSetDriftDetectionDetails.ReadOnly {
    override val driftStatus
        : Option[zio.aws.cloudformation.model.StackSetDriftStatus] = scala
      .Option(impl.driftStatus())
      .map(value =>
        zio.aws.cloudformation.model.StackSetDriftStatus.wrap(value)
      )
    override val driftDetectionStatus
        : Option[zio.aws.cloudformation.model.StackSetDriftDetectionStatus] =
      scala
        .Option(impl.driftDetectionStatus())
        .map(value =>
          zio.aws.cloudformation.model.StackSetDriftDetectionStatus.wrap(value)
        )
    override val lastDriftCheckTimestamp: Option[Timestamp] = scala
      .Option(impl.lastDriftCheckTimestamp())
      .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
    override val totalStackInstancesCount: Option[TotalStackInstancesCount] =
      scala
        .Option(impl.totalStackInstancesCount())
        .map(value =>
          zio.aws.cloudformation.model.primitives
            .TotalStackInstancesCount(value)
        )
    override val driftedStackInstancesCount
        : Option[DriftedStackInstancesCount] = scala
      .Option(impl.driftedStackInstancesCount())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .DriftedStackInstancesCount(value)
      )
    override val inSyncStackInstancesCount: Option[InSyncStackInstancesCount] =
      scala
        .Option(impl.inSyncStackInstancesCount())
        .map(value =>
          zio.aws.cloudformation.model.primitives
            .InSyncStackInstancesCount(value)
        )
    override val inProgressStackInstancesCount
        : Option[InProgressStackInstancesCount] = scala
      .Option(impl.inProgressStackInstancesCount())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .InProgressStackInstancesCount(value)
      )
    override val failedStackInstancesCount: Option[FailedStackInstancesCount] =
      scala
        .Option(impl.failedStackInstancesCount())
        .map(value =>
          zio.aws.cloudformation.model.primitives
            .FailedStackInstancesCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionDetails
  ): zio.aws.cloudformation.model.StackSetDriftDetectionDetails.ReadOnly =
    new Wrapper(impl)
}
