package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait RequiresRecreation {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.RequiresRecreation
}
object RequiresRecreation {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.RequiresRecreation
  ): zio.aws.cloudformation.model.RequiresRecreation = value match {
    case software.amazon.awssdk.services.cloudformation.model.RequiresRecreation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.RequiresRecreation.NEVER =>
      val r = Never
      r
    case software.amazon.awssdk.services.cloudformation.model.RequiresRecreation.CONDITIONALLY =>
      val r = Conditionally
      r
    case software.amazon.awssdk.services.cloudformation.model.RequiresRecreation.ALWAYS =>
      val r = Always
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.RequiresRecreation {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.RequiresRecreation =
      software.amazon.awssdk.services.cloudformation.model.RequiresRecreation.UNKNOWN_TO_SDK_VERSION
  }
  case object Never extends zio.aws.cloudformation.model.RequiresRecreation {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.RequiresRecreation =
      software.amazon.awssdk.services.cloudformation.model.RequiresRecreation.NEVER
  }
  case object Conditionally
      extends zio.aws.cloudformation.model.RequiresRecreation {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.RequiresRecreation =
      software.amazon.awssdk.services.cloudformation.model.RequiresRecreation.CONDITIONALLY
  }
  case object Always extends zio.aws.cloudformation.model.RequiresRecreation {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.RequiresRecreation =
      software.amazon.awssdk.services.cloudformation.model.RequiresRecreation.ALWAYS
  }
}
