package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTypeVersionsResponse(
    typeVersionSummaries: Option[
      Iterable[zio.aws.cloudformation.model.TypeVersionSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse = {
    import ListTypeVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse
      .builder()
      .optionallyWith(
        typeVersionSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.typeVersionSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ListTypeVersionsResponse.ReadOnly =
    zio.aws.cloudformation.model.ListTypeVersionsResponse.wrap(buildAwsValue())
}
object ListTypeVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListTypeVersionsResponse =
      zio.aws.cloudformation.model.ListTypeVersionsResponse(
        typeVersionSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def typeVersionSummaries
        : Option[List[zio.aws.cloudformation.model.TypeVersionSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getTypeVersionSummaries: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.TypeVersionSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("typeVersionSummaries", typeVersionSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse
  ) extends zio.aws.cloudformation.model.ListTypeVersionsResponse.ReadOnly {
    override val typeVersionSummaries: Option[
      List[zio.aws.cloudformation.model.TypeVersionSummary.ReadOnly]
    ] = scala
      .Option(impl.typeVersionSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.TypeVersionSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse
  ): zio.aws.cloudformation.model.ListTypeVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
