package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListStackSetOperationResultsResponse(
    summaries: Option[
      Iterable[zio.aws.cloudformation.model.StackSetOperationResultSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse = {
    import ListStackSetOperationResultsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse
      .builder()
      .optionallyWith(
        summaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ListStackSetOperationResultsResponse.ReadOnly =
    zio.aws.cloudformation.model.ListStackSetOperationResultsResponse
      .wrap(buildAwsValue())
}
object ListStackSetOperationResultsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.ListStackSetOperationResultsResponse =
      zio.aws.cloudformation.model.ListStackSetOperationResultsResponse(
        summaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def summaries: Option[
      List[zio.aws.cloudformation.model.StackSetOperationResultSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getSummaries: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.StackSetOperationResultSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaries", summaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse
  ) extends zio.aws.cloudformation.model.ListStackSetOperationResultsResponse.ReadOnly {
    override val summaries: Option[
      List[zio.aws.cloudformation.model.StackSetOperationResultSummary.ReadOnly]
    ] = scala
      .Option(impl.summaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.StackSetOperationResultSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse
  ): zio.aws.cloudformation.model.ListStackSetOperationResultsResponse.ReadOnly =
    new Wrapper(impl)
}
