package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ExportValue,
  ExportName,
  StackId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Export(
    exportingStackId: Option[StackId] = None,
    name: Option[ExportName] = None,
    value: Option[ExportValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.Export = {
    import Export.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.Export
      .builder()
      .optionallyWith(
        exportingStackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.exportingStackId)
      .optionallyWith(
        name.map(value => ExportName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        value.map(value => ExportValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.Export.ReadOnly =
    zio.aws.cloudformation.model.Export.wrap(buildAwsValue())
}
object Export {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.Export
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.Export =
      zio.aws.cloudformation.model.Export(
        exportingStackId.map(value => value),
        name.map(value => value),
        value.map(value => value)
      )
    def exportingStackId: Option[StackId]
    def name: Option[ExportName]
    def value: Option[ExportValue]
    def getExportingStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("exportingStackId", exportingStackId)
    def getName: ZIO[Any, AwsError, ExportName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, ExportValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.Export
  ) extends zio.aws.cloudformation.model.Export.ReadOnly {
    override val exportingStackId: Option[StackId] = scala
      .Option(impl.exportingStackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val name: Option[ExportName] = scala
      .Option(impl.name())
      .map(value => zio.aws.cloudformation.model.primitives.ExportName(value))
    override val value: Option[ExportValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.cloudformation.model.primitives.ExportValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.Export
  ): zio.aws.cloudformation.model.Export.ReadOnly = new Wrapper(impl)
}
