package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  TypeVersionId,
  PublisherId,
  RoleArn,
  TypeSchema,
  PublicVersionNumber,
  OptionalSecureUrl,
  TypeArn,
  Timestamp,
  AutoUpdate,
  IsDefaultVersion,
  IsActivated,
  Description,
  TypeName,
  TypeTestsStatusDescription,
  ConfigurationSchema
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeTypeResponse(
    arn: Option[TypeArn] = None,
    `type`: Option[zio.aws.cloudformation.model.RegistryType] = None,
    typeName: Option[TypeName] = None,
    defaultVersionId: Option[TypeVersionId] = None,
    isDefaultVersion: Option[IsDefaultVersion] = None,
    typeTestsStatus: Option[zio.aws.cloudformation.model.TypeTestsStatus] =
      None,
    typeTestsStatusDescription: Option[TypeTestsStatusDescription] = None,
    description: Option[Description] = None,
    schema: Option[TypeSchema] = None,
    provisioningType: Option[zio.aws.cloudformation.model.ProvisioningType] =
      None,
    deprecatedStatus: Option[zio.aws.cloudformation.model.DeprecatedStatus] =
      None,
    loggingConfig: Option[zio.aws.cloudformation.model.LoggingConfig] = None,
    requiredActivatedTypes: Option[
      Iterable[zio.aws.cloudformation.model.RequiredActivatedType]
    ] = None,
    executionRoleArn: Option[RoleArn] = None,
    visibility: Option[zio.aws.cloudformation.model.Visibility] = None,
    sourceUrl: Option[OptionalSecureUrl] = None,
    documentationUrl: Option[OptionalSecureUrl] = None,
    lastUpdated: Option[Timestamp] = None,
    timeCreated: Option[Timestamp] = None,
    configurationSchema: Option[ConfigurationSchema] = None,
    publisherId: Option[PublisherId] = None,
    originalTypeName: Option[TypeName] = None,
    originalTypeArn: Option[TypeArn] = None,
    publicVersionNumber: Option[PublicVersionNumber] = None,
    latestPublicVersion: Option[PublicVersionNumber] = None,
    isActivated: Option[IsActivated] = None,
    autoUpdate: Option[AutoUpdate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeTypeResponse = {
    import DescribeTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeTypeResponse
      .builder()
      .optionallyWith(
        arn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        defaultVersionId.map(value =>
          TypeVersionId.unwrap(value): java.lang.String
        )
      )(_.defaultVersionId)
      .optionallyWith(
        isDefaultVersion.map(value =>
          IsDefaultVersion.unwrap(value): java.lang.Boolean
        )
      )(_.isDefaultVersion)
      .optionallyWith(typeTestsStatus.map(value => value.unwrap))(
        _.typeTestsStatus
      )
      .optionallyWith(
        typeTestsStatusDescription.map(value =>
          TypeTestsStatusDescription.unwrap(value): java.lang.String
        )
      )(_.typeTestsStatusDescription)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        schema.map(value => TypeSchema.unwrap(value): java.lang.String)
      )(_.schema)
      .optionallyWith(provisioningType.map(value => value.unwrap))(
        _.provisioningType
      )
      .optionallyWith(deprecatedStatus.map(value => value.unwrap))(
        _.deprecatedStatus
      )
      .optionallyWith(loggingConfig.map(value => value.buildAwsValue()))(
        _.loggingConfig
      )
      .optionallyWith(
        requiredActivatedTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requiredActivatedTypes)
      .optionallyWith(
        executionRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.executionRoleArn)
      .optionallyWith(visibility.map(value => value.unwrap))(_.visibility)
      .optionallyWith(
        sourceUrl.map(value =>
          OptionalSecureUrl.unwrap(value): java.lang.String
        )
      )(_.sourceUrl)
      .optionallyWith(
        documentationUrl.map(value =>
          OptionalSecureUrl.unwrap(value): java.lang.String
        )
      )(_.documentationUrl)
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .optionallyWith(
        timeCreated.map(value => Timestamp.unwrap(value): Instant)
      )(_.timeCreated)
      .optionallyWith(
        configurationSchema.map(value =>
          ConfigurationSchema.unwrap(value): java.lang.String
        )
      )(_.configurationSchema)
      .optionallyWith(
        publisherId.map(value => PublisherId.unwrap(value): java.lang.String)
      )(_.publisherId)
      .optionallyWith(
        originalTypeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.originalTypeName)
      .optionallyWith(
        originalTypeArn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.originalTypeArn)
      .optionallyWith(
        publicVersionNumber.map(value =>
          PublicVersionNumber.unwrap(value): java.lang.String
        )
      )(_.publicVersionNumber)
      .optionallyWith(
        latestPublicVersion.map(value =>
          PublicVersionNumber.unwrap(value): java.lang.String
        )
      )(_.latestPublicVersion)
      .optionallyWith(
        isActivated.map(value => IsActivated.unwrap(value): java.lang.Boolean)
      )(_.isActivated)
      .optionallyWith(
        autoUpdate.map(value => AutoUpdate.unwrap(value): java.lang.Boolean)
      )(_.autoUpdate)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.DescribeTypeResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeTypeResponse.wrap(buildAwsValue())
}
object DescribeTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeTypeResponse =
      zio.aws.cloudformation.model.DescribeTypeResponse(
        arn.map(value => value),
        `type`.map(value => value),
        typeName.map(value => value),
        defaultVersionId.map(value => value),
        isDefaultVersion.map(value => value),
        typeTestsStatus.map(value => value),
        typeTestsStatusDescription.map(value => value),
        description.map(value => value),
        schema.map(value => value),
        provisioningType.map(value => value),
        deprecatedStatus.map(value => value),
        loggingConfig.map(value => value.asEditable),
        requiredActivatedTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        executionRoleArn.map(value => value),
        visibility.map(value => value),
        sourceUrl.map(value => value),
        documentationUrl.map(value => value),
        lastUpdated.map(value => value),
        timeCreated.map(value => value),
        configurationSchema.map(value => value),
        publisherId.map(value => value),
        originalTypeName.map(value => value),
        originalTypeArn.map(value => value),
        publicVersionNumber.map(value => value),
        latestPublicVersion.map(value => value),
        isActivated.map(value => value),
        autoUpdate.map(value => value)
      )
    def arn: Option[TypeArn]
    def `type`: Option[zio.aws.cloudformation.model.RegistryType]
    def typeName: Option[TypeName]
    def defaultVersionId: Option[TypeVersionId]
    def isDefaultVersion: Option[IsDefaultVersion]
    def typeTestsStatus: Option[zio.aws.cloudformation.model.TypeTestsStatus]
    def typeTestsStatusDescription: Option[TypeTestsStatusDescription]
    def description: Option[Description]
    def schema: Option[TypeSchema]
    def provisioningType: Option[zio.aws.cloudformation.model.ProvisioningType]
    def deprecatedStatus: Option[zio.aws.cloudformation.model.DeprecatedStatus]
    def loggingConfig
        : Option[zio.aws.cloudformation.model.LoggingConfig.ReadOnly]
    def requiredActivatedTypes: Option[
      List[zio.aws.cloudformation.model.RequiredActivatedType.ReadOnly]
    ]
    def executionRoleArn: Option[RoleArn]
    def visibility: Option[zio.aws.cloudformation.model.Visibility]
    def sourceUrl: Option[OptionalSecureUrl]
    def documentationUrl: Option[OptionalSecureUrl]
    def lastUpdated: Option[Timestamp]
    def timeCreated: Option[Timestamp]
    def configurationSchema: Option[ConfigurationSchema]
    def publisherId: Option[PublisherId]
    def originalTypeName: Option[TypeName]
    def originalTypeArn: Option[TypeArn]
    def publicVersionNumber: Option[PublicVersionNumber]
    def latestPublicVersion: Option[PublicVersionNumber]
    def isActivated: Option[IsActivated]
    def autoUpdate: Option[AutoUpdate]
    def getArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, zio.aws.cloudformation.model.RegistryType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getDefaultVersionId: ZIO[Any, AwsError, TypeVersionId] =
      AwsError.unwrapOptionField("defaultVersionId", defaultVersionId)
    def getIsDefaultVersion: ZIO[Any, AwsError, IsDefaultVersion] =
      AwsError.unwrapOptionField("isDefaultVersion", isDefaultVersion)
    def getTypeTestsStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.TypeTestsStatus] =
      AwsError.unwrapOptionField("typeTestsStatus", typeTestsStatus)
    def getTypeTestsStatusDescription
        : ZIO[Any, AwsError, TypeTestsStatusDescription] =
      AwsError.unwrapOptionField(
        "typeTestsStatusDescription",
        typeTestsStatusDescription
      )
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSchema: ZIO[Any, AwsError, TypeSchema] =
      AwsError.unwrapOptionField("schema", schema)
    def getProvisioningType
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ProvisioningType] =
      AwsError.unwrapOptionField("provisioningType", provisioningType)
    def getDeprecatedStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.DeprecatedStatus] =
      AwsError.unwrapOptionField("deprecatedStatus", deprecatedStatus)
    def getLoggingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.LoggingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfig", loggingConfig)
    def getRequiredActivatedTypes: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.RequiredActivatedType.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "requiredActivatedTypes",
      requiredActivatedTypes
    )
    def getExecutionRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getVisibility
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.Visibility] =
      AwsError.unwrapOptionField("visibility", visibility)
    def getSourceUrl: ZIO[Any, AwsError, OptionalSecureUrl] =
      AwsError.unwrapOptionField("sourceUrl", sourceUrl)
    def getDocumentationUrl: ZIO[Any, AwsError, OptionalSecureUrl] =
      AwsError.unwrapOptionField("documentationUrl", documentationUrl)
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getTimeCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timeCreated", timeCreated)
    def getConfigurationSchema: ZIO[Any, AwsError, ConfigurationSchema] =
      AwsError.unwrapOptionField("configurationSchema", configurationSchema)
    def getPublisherId: ZIO[Any, AwsError, PublisherId] =
      AwsError.unwrapOptionField("publisherId", publisherId)
    def getOriginalTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("originalTypeName", originalTypeName)
    def getOriginalTypeArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("originalTypeArn", originalTypeArn)
    def getPublicVersionNumber: ZIO[Any, AwsError, PublicVersionNumber] =
      AwsError.unwrapOptionField("publicVersionNumber", publicVersionNumber)
    def getLatestPublicVersion: ZIO[Any, AwsError, PublicVersionNumber] =
      AwsError.unwrapOptionField("latestPublicVersion", latestPublicVersion)
    def getIsActivated: ZIO[Any, AwsError, IsActivated] =
      AwsError.unwrapOptionField("isActivated", isActivated)
    def getAutoUpdate: ZIO[Any, AwsError, AutoUpdate] =
      AwsError.unwrapOptionField("autoUpdate", autoUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeTypeResponse
  ) extends zio.aws.cloudformation.model.DescribeTypeResponse.ReadOnly {
    override val arn: Option[TypeArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
    override val `type`: Option[zio.aws.cloudformation.model.RegistryType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.cloudformation.model.RegistryType.wrap(value))
    override val typeName: Option[TypeName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val defaultVersionId: Option[TypeVersionId] = scala
      .Option(impl.defaultVersionId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TypeVersionId(value)
      )
    override val isDefaultVersion: Option[IsDefaultVersion] = scala
      .Option(impl.isDefaultVersion())
      .map(value =>
        zio.aws.cloudformation.model.primitives.IsDefaultVersion(value)
      )
    override val typeTestsStatus
        : Option[zio.aws.cloudformation.model.TypeTestsStatus] = scala
      .Option(impl.typeTestsStatus())
      .map(value => zio.aws.cloudformation.model.TypeTestsStatus.wrap(value))
    override val typeTestsStatusDescription
        : Option[TypeTestsStatusDescription] = scala
      .Option(impl.typeTestsStatusDescription())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .TypeTestsStatusDescription(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val schema: Option[TypeSchema] = scala
      .Option(impl.schema())
      .map(value => zio.aws.cloudformation.model.primitives.TypeSchema(value))
    override val provisioningType
        : Option[zio.aws.cloudformation.model.ProvisioningType] = scala
      .Option(impl.provisioningType())
      .map(value => zio.aws.cloudformation.model.ProvisioningType.wrap(value))
    override val deprecatedStatus
        : Option[zio.aws.cloudformation.model.DeprecatedStatus] = scala
      .Option(impl.deprecatedStatus())
      .map(value => zio.aws.cloudformation.model.DeprecatedStatus.wrap(value))
    override val loggingConfig
        : Option[zio.aws.cloudformation.model.LoggingConfig.ReadOnly] = scala
      .Option(impl.loggingConfig())
      .map(value => zio.aws.cloudformation.model.LoggingConfig.wrap(value))
    override val requiredActivatedTypes: Option[
      List[zio.aws.cloudformation.model.RequiredActivatedType.ReadOnly]
    ] = scala
      .Option(impl.requiredActivatedTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.RequiredActivatedType.wrap(item)
        }.toList
      )
    override val executionRoleArn: Option[RoleArn] = scala
      .Option(impl.executionRoleArn())
      .map(value => zio.aws.cloudformation.model.primitives.RoleArn(value))
    override val visibility: Option[zio.aws.cloudformation.model.Visibility] =
      scala
        .Option(impl.visibility())
        .map(value => zio.aws.cloudformation.model.Visibility.wrap(value))
    override val sourceUrl: Option[OptionalSecureUrl] = scala
      .Option(impl.sourceUrl())
      .map(value =>
        zio.aws.cloudformation.model.primitives.OptionalSecureUrl(value)
      )
    override val documentationUrl: Option[OptionalSecureUrl] = scala
      .Option(impl.documentationUrl())
      .map(value =>
        zio.aws.cloudformation.model.primitives.OptionalSecureUrl(value)
      )
    override val lastUpdated: Option[Timestamp] = scala
      .Option(impl.lastUpdated())
      .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
    override val timeCreated: Option[Timestamp] = scala
      .Option(impl.timeCreated())
      .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
    override val configurationSchema: Option[ConfigurationSchema] = scala
      .Option(impl.configurationSchema())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ConfigurationSchema(value)
      )
    override val publisherId: Option[PublisherId] = scala
      .Option(impl.publisherId())
      .map(value => zio.aws.cloudformation.model.primitives.PublisherId(value))
    override val originalTypeName: Option[TypeName] = scala
      .Option(impl.originalTypeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val originalTypeArn: Option[TypeArn] = scala
      .Option(impl.originalTypeArn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
    override val publicVersionNumber: Option[PublicVersionNumber] = scala
      .Option(impl.publicVersionNumber())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PublicVersionNumber(value)
      )
    override val latestPublicVersion: Option[PublicVersionNumber] = scala
      .Option(impl.latestPublicVersion())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PublicVersionNumber(value)
      )
    override val isActivated: Option[IsActivated] = scala
      .Option(impl.isActivated())
      .map(value => zio.aws.cloudformation.model.primitives.IsActivated(value))
    override val autoUpdate: Option[AutoUpdate] = scala
      .Option(impl.autoUpdate())
      .map(value => zio.aws.cloudformation.model.primitives.AutoUpdate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeTypeResponse
  ): zio.aws.cloudformation.model.DescribeTypeResponse.ReadOnly = new Wrapper(
    impl
  )
}
