package zio.aws.cloudformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeStackResourceResponse(
    stackResourceDetail: Option[
      zio.aws.cloudformation.model.StackResourceDetail
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse = {
    import DescribeStackResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse
      .builder()
      .optionallyWith(stackResourceDetail.map(value => value.buildAwsValue()))(
        _.stackResourceDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeStackResourceResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeStackResourceResponse
      .wrap(buildAwsValue())
}
object DescribeStackResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeStackResourceResponse =
      zio.aws.cloudformation.model.DescribeStackResourceResponse(
        stackResourceDetail.map(value => value.asEditable)
      )
    def stackResourceDetail
        : Option[zio.aws.cloudformation.model.StackResourceDetail.ReadOnly]
    def getStackResourceDetail: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackResourceDetail.ReadOnly
    ] = AwsError.unwrapOptionField("stackResourceDetail", stackResourceDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse
  ) extends zio.aws.cloudformation.model.DescribeStackResourceResponse.ReadOnly {
    override val stackResourceDetail
        : Option[zio.aws.cloudformation.model.StackResourceDetail.ReadOnly] =
      scala
        .Option(impl.stackResourceDetail())
        .map(value =>
          zio.aws.cloudformation.model.StackResourceDetail.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse
  ): zio.aws.cloudformation.model.DescribeStackResourceResponse.ReadOnly =
    new Wrapper(impl)
}
