package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait StackSetOperationResultStatus {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus
}
object StackSetOperationResultStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus
  ): zio.aws.cloudformation.model.StackSetOperationResultStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus.CANCELLED =>
      val r = CANCELLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.StackSetOperationResultStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING
      extends zio.aws.cloudformation.model.StackSetOperationResultStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus.PENDING
  }
  case object RUNNING
      extends zio.aws.cloudformation.model.StackSetOperationResultStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus.RUNNING
  }
  case object SUCCEEDED
      extends zio.aws.cloudformation.model.StackSetOperationResultStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus.SUCCEEDED
  }
  case object FAILED
      extends zio.aws.cloudformation.model.StackSetOperationResultStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus.FAILED
  }
  case object CANCELLED
      extends zio.aws.cloudformation.model.StackSetOperationResultStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus.CANCELLED
  }
}
