package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait StackDriftDetectionStatus {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.StackDriftDetectionStatus
}
object StackDriftDetectionStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.StackDriftDetectionStatus
  ): zio.aws.cloudformation.model.StackDriftDetectionStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.StackDriftDetectionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.StackDriftDetectionStatus.DETECTION_IN_PROGRESS =>
      val r = DETECTION_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.StackDriftDetectionStatus.DETECTION_FAILED =>
      val r = DETECTION_FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.StackDriftDetectionStatus.DETECTION_COMPLETE =>
      val r = DETECTION_COMPLETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.StackDriftDetectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackDriftDetectionStatus =
      software.amazon.awssdk.services.cloudformation.model.StackDriftDetectionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object DETECTION_IN_PROGRESS
      extends zio.aws.cloudformation.model.StackDriftDetectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackDriftDetectionStatus =
      software.amazon.awssdk.services.cloudformation.model.StackDriftDetectionStatus.DETECTION_IN_PROGRESS
  }
  case object DETECTION_FAILED
      extends zio.aws.cloudformation.model.StackDriftDetectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackDriftDetectionStatus =
      software.amazon.awssdk.services.cloudformation.model.StackDriftDetectionStatus.DETECTION_FAILED
  }
  case object DETECTION_COMPLETE
      extends zio.aws.cloudformation.model.StackDriftDetectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackDriftDetectionStatus =
      software.amazon.awssdk.services.cloudformation.model.StackDriftDetectionStatus.DETECTION_COMPLETE
  }
}
