package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{Type, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RollbackTrigger(arn: Arn, `type`: Type) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.RollbackTrigger = {
    import RollbackTrigger.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.RollbackTrigger
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .`type`(Type.unwrap(`type`): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.RollbackTrigger.ReadOnly =
    zio.aws.cloudformation.model.RollbackTrigger.wrap(buildAwsValue())
}
object RollbackTrigger {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.RollbackTrigger
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.RollbackTrigger =
      zio.aws.cloudformation.model.RollbackTrigger(arn, `type`)
    def arn: Arn
    def `type`: Type
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getType: ZIO[Any, Nothing, Type] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.RollbackTrigger
  ) extends zio.aws.cloudformation.model.RollbackTrigger.ReadOnly {
    override val arn: Arn =
      zio.aws.cloudformation.model.primitives.Arn(impl.arn())
    override val `type`: Type =
      zio.aws.cloudformation.model.primitives.Type(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.RollbackTrigger
  ): zio.aws.cloudformation.model.RollbackTrigger.ReadOnly = new Wrapper(impl)
}
