package zio.aws.cloudformation.model
import java.lang.Integer
import zio.aws.cloudformation.model.primitives.{NextToken, MaxResults}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTypesRequest(
    visibility: Option[zio.aws.cloudformation.model.Visibility] = None,
    provisioningType: Option[zio.aws.cloudformation.model.ProvisioningType] =
      None,
    deprecatedStatus: Option[zio.aws.cloudformation.model.DeprecatedStatus] =
      None,
    `type`: Option[zio.aws.cloudformation.model.RegistryType] = None,
    filters: Option[zio.aws.cloudformation.model.TypeFilters] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListTypesRequest = {
    import ListTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListTypesRequest
      .builder()
      .optionallyWith(visibility.map(value => value.unwrap))(_.visibility)
      .optionallyWith(provisioningType.map(value => value.unwrap))(
        _.provisioningType
      )
      .optionallyWith(deprecatedStatus.map(value => value.unwrap))(
        _.deprecatedStatus
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ListTypesRequest.ReadOnly =
    zio.aws.cloudformation.model.ListTypesRequest.wrap(buildAwsValue())
}
object ListTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListTypesRequest =
      zio.aws.cloudformation.model.ListTypesRequest(
        visibility.map(value => value),
        provisioningType.map(value => value),
        deprecatedStatus.map(value => value),
        `type`.map(value => value),
        filters.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def visibility: Option[zio.aws.cloudformation.model.Visibility]
    def provisioningType: Option[zio.aws.cloudformation.model.ProvisioningType]
    def deprecatedStatus: Option[zio.aws.cloudformation.model.DeprecatedStatus]
    def `type`: Option[zio.aws.cloudformation.model.RegistryType]
    def filters: Option[zio.aws.cloudformation.model.TypeFilters.ReadOnly]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getVisibility
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.Visibility] =
      AwsError.unwrapOptionField("visibility", visibility)
    def getProvisioningType
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ProvisioningType] =
      AwsError.unwrapOptionField("provisioningType", provisioningType)
    def getDeprecatedStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.DeprecatedStatus] =
      AwsError.unwrapOptionField("deprecatedStatus", deprecatedStatus)
    def getType: ZIO[Any, AwsError, zio.aws.cloudformation.model.RegistryType] =
      AwsError.unwrapOptionField("type", `type`)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.TypeFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypesRequest
  ) extends zio.aws.cloudformation.model.ListTypesRequest.ReadOnly {
    override val visibility: Option[zio.aws.cloudformation.model.Visibility] =
      scala
        .Option(impl.visibility())
        .map(value => zio.aws.cloudformation.model.Visibility.wrap(value))
    override val provisioningType
        : Option[zio.aws.cloudformation.model.ProvisioningType] = scala
      .Option(impl.provisioningType())
      .map(value => zio.aws.cloudformation.model.ProvisioningType.wrap(value))
    override val deprecatedStatus
        : Option[zio.aws.cloudformation.model.DeprecatedStatus] = scala
      .Option(impl.deprecatedStatus())
      .map(value => zio.aws.cloudformation.model.DeprecatedStatus.wrap(value))
    override val `type`: Option[zio.aws.cloudformation.model.RegistryType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.cloudformation.model.RegistryType.wrap(value))
    override val filters
        : Option[zio.aws.cloudformation.model.TypeFilters.ReadOnly] = scala
      .Option(impl.filters())
      .map(value => zio.aws.cloudformation.model.TypeFilters.wrap(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.cloudformation.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypesRequest
  ): zio.aws.cloudformation.model.ListTypesRequest.ReadOnly = new Wrapper(impl)
}
