package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  TransformName,
  CapabilitiesReason,
  ResourceType,
  Description,
  Version,
  Metadata
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetTemplateSummaryResponse(
    parameters: Option[
      Iterable[zio.aws.cloudformation.model.ParameterDeclaration]
    ] = None,
    description: Option[Description] = None,
    capabilities: Option[Iterable[zio.aws.cloudformation.model.Capability]] =
      None,
    capabilitiesReason: Option[CapabilitiesReason] = None,
    resourceTypes: Option[Iterable[ResourceType]] = None,
    version: Option[Version] = None,
    metadata: Option[Metadata] = None,
    declaredTransforms: Option[Iterable[TransformName]] = None,
    resourceIdentifierSummaries: Option[
      Iterable[zio.aws.cloudformation.model.ResourceIdentifierSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse = {
    import GetTemplateSummaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse
      .builder()
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        capabilitiesReason.map(value =>
          CapabilitiesReason.unwrap(value): java.lang.String
        )
      )(_.capabilitiesReason)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            ResourceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(
        declaredTransforms.map(value =>
          value.map { item =>
            TransformName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.declaredTransforms)
      .optionallyWith(
        resourceIdentifierSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceIdentifierSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.GetTemplateSummaryResponse.ReadOnly =
    zio.aws.cloudformation.model.GetTemplateSummaryResponse
      .wrap(buildAwsValue())
}
object GetTemplateSummaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.GetTemplateSummaryResponse =
      zio.aws.cloudformation.model.GetTemplateSummaryResponse(
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        description.map(value => value),
        capabilities.map(value => value),
        capabilitiesReason.map(value => value),
        resourceTypes.map(value => value),
        version.map(value => value),
        metadata.map(value => value),
        declaredTransforms.map(value => value),
        resourceIdentifierSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def parameters: Option[
      List[zio.aws.cloudformation.model.ParameterDeclaration.ReadOnly]
    ]
    def description: Option[Description]
    def capabilities: Option[List[zio.aws.cloudformation.model.Capability]]
    def capabilitiesReason: Option[CapabilitiesReason]
    def resourceTypes: Option[List[ResourceType]]
    def version: Option[Version]
    def metadata: Option[Metadata]
    def declaredTransforms: Option[List[TransformName]]
    def resourceIdentifierSummaries: Option[
      List[zio.aws.cloudformation.model.ResourceIdentifierSummary.ReadOnly]
    ]
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.ParameterDeclaration.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Capability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getCapabilitiesReason: ZIO[Any, AwsError, CapabilitiesReason] =
      AwsError.unwrapOptionField("capabilitiesReason", capabilitiesReason)
    def getResourceTypes: ZIO[Any, AwsError, List[ResourceType]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getDeclaredTransforms: ZIO[Any, AwsError, List[TransformName]] =
      AwsError.unwrapOptionField("declaredTransforms", declaredTransforms)
    def getResourceIdentifierSummaries: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.ResourceIdentifierSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceIdentifierSummaries",
      resourceIdentifierSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse
  ) extends zio.aws.cloudformation.model.GetTemplateSummaryResponse.ReadOnly {
    override val parameters: Option[
      List[zio.aws.cloudformation.model.ParameterDeclaration.ReadOnly]
    ] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.ParameterDeclaration.wrap(item)
        }.toList
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val capabilities
        : Option[List[zio.aws.cloudformation.model.Capability]] = scala
      .Option(impl.capabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Capability.wrap(item)
        }.toList
      )
    override val capabilitiesReason: Option[CapabilitiesReason] = scala
      .Option(impl.capabilitiesReason())
      .map(value =>
        zio.aws.cloudformation.model.primitives.CapabilitiesReason(value)
      )
    override val resourceTypes: Option[List[ResourceType]] = scala
      .Option(impl.resourceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.ResourceType(item)
        }.toList
      )
    override val version: Option[Version] = scala
      .Option(impl.version())
      .map(value => zio.aws.cloudformation.model.primitives.Version(value))
    override val metadata: Option[Metadata] = scala
      .Option(impl.metadata())
      .map(value => zio.aws.cloudformation.model.primitives.Metadata(value))
    override val declaredTransforms: Option[List[TransformName]] = scala
      .Option(impl.declaredTransforms())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.TransformName(item)
        }.toList
      )
    override val resourceIdentifierSummaries: Option[
      List[zio.aws.cloudformation.model.ResourceIdentifierSummary.ReadOnly]
    ] = scala
      .Option(impl.resourceIdentifierSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.ResourceIdentifierSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse
  ): zio.aws.cloudformation.model.GetTemplateSummaryResponse.ReadOnly =
    new Wrapper(impl)
}
