package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.ClientRequestToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateStackInstancesResponse(
    operationId: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesResponse = {
    import CreateStackInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesResponse
      .builder()
      .optionallyWith(
        operationId.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.operationId)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.CreateStackInstancesResponse.ReadOnly =
    zio.aws.cloudformation.model.CreateStackInstancesResponse
      .wrap(buildAwsValue())
}
object CreateStackInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.CreateStackInstancesResponse =
      zio.aws.cloudformation.model
        .CreateStackInstancesResponse(operationId.map(value => value))
    def operationId: Option[ClientRequestToken]
    def getOperationId: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("operationId", operationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesResponse
  ) extends zio.aws.cloudformation.model.CreateStackInstancesResponse.ReadOnly {
    override val operationId: Option[ClientRequestToken] = scala
      .Option(impl.operationId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesResponse
  ): zio.aws.cloudformation.model.CreateStackInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
