package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.AccountGateStatusReason
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AccountGateResult(
    status: Option[zio.aws.cloudformation.model.AccountGateStatus] = None,
    statusReason: Option[AccountGateStatusReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.AccountGateResult = {
    import AccountGateResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.AccountGateResult
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusReason.map(value =>
          AccountGateStatusReason.unwrap(value): java.lang.String
        )
      )(_.statusReason)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.AccountGateResult.ReadOnly =
    zio.aws.cloudformation.model.AccountGateResult.wrap(buildAwsValue())
}
object AccountGateResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.AccountGateResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.AccountGateResult =
      zio.aws.cloudformation.model.AccountGateResult(
        status.map(value => value),
        statusReason.map(value => value)
      )
    def status: Option[zio.aws.cloudformation.model.AccountGateStatus]
    def statusReason: Option[AccountGateStatusReason]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.AccountGateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, AccountGateStatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.AccountGateResult
  ) extends zio.aws.cloudformation.model.AccountGateResult.ReadOnly {
    override val status
        : Option[zio.aws.cloudformation.model.AccountGateStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.cloudformation.model.AccountGateStatus.wrap(value))
    override val statusReason: Option[AccountGateStatusReason] = scala
      .Option(impl.statusReason())
      .map(value =>
        zio.aws.cloudformation.model.primitives.AccountGateStatusReason(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.AccountGateResult
  ): zio.aws.cloudformation.model.AccountGateResult.ReadOnly = new Wrapper(impl)
}
